/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ModuleDiscoverer;

public class CompositeModuleDiscoverer
implements ModuleDiscoverer {
    private final ModuleDiscoverer[] moduleDiscoverers;

    public CompositeModuleDiscoverer(ModuleDiscoverer ... moduleDiscoverers) {
        Preconditions.checkArgument((moduleDiscoverers.length > 0 ? 1 : 0) != 0, (String)"moduleDiscoverers cannot be empty");
        this.moduleDiscoverers = moduleDiscoverers;
    }

    @Override
    public List<MuleModule> discover() {
        ArrayList<MuleModule> muleModules = new ArrayList<MuleModule>();
        for (ModuleDiscoverer discoverer : this.moduleDiscoverers) {
            muleModules.addAll(discoverer.discover());
        }
        return muleModules;
    }
}

