/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ContainerClassLoaderFilterFactory;
import org.mule.runtime.container.internal.ContainerModuleDiscoverer;
import org.mule.runtime.container.internal.ContainerOnlyLookupStrategy;
import org.mule.runtime.container.internal.DefaultModuleRepository;
import org.mule.runtime.container.internal.FilteringContainerClassLoader;
import org.mule.runtime.container.internal.MuleClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.EnumerationAdapter;
import org.mule.runtime.module.artifact.classloader.ExportedService;
import org.mule.runtime.module.artifact.classloader.FilteringArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;

public class ContainerClassLoaderFactory {
    public static final Set<String> SYSTEM_PACKAGES = ImmutableSet.of((Object)"org.mule.runtime", (Object)"com.mulesoft.mule.runtime");
    public static final Set<String> BOOT_PACKAGES = ImmutableSet.of((Object)"com.yourkit");
    private final ModuleRepository moduleRepository;

    public ContainerClassLoaderFactory(ModuleRepository moduleRepository) {
        Preconditions.checkArgument((moduleRepository != null ? 1 : 0) != 0, (String)"moduleRepository cannot be null");
        this.moduleRepository = moduleRepository;
    }

    public ContainerClassLoaderFactory() {
        this(new DefaultModuleRepository(new ContainerModuleDiscoverer(ContainerClassLoaderFactory.class.getClassLoader())));
    }

    public ArtifactClassLoader createContainerClassLoader(ClassLoader parentClassLoader) {
        List<MuleModule> muleModules = this.moduleRepository.getModules();
        ClassLoaderLookupPolicy containerLookupPolicy = this.getContainerClassLoaderLookupPolicy(parentClassLoader, muleModules);
        return this.createArtifactClassLoader(parentClassLoader, muleModules, containerLookupPolicy, new ArtifactDescriptor("mule"));
    }

    protected ClassLoaderLookupPolicy getContainerClassLoaderLookupPolicy(ClassLoader parentClassLoader, List<MuleModule> muleModules) {
        HashSet<String> parentOnlyPackages = new HashSet<String>(this.getBootPackages());
        parentOnlyPackages.addAll(SYSTEM_PACKAGES);
        Map<String, LookupStrategy> lookupStrategies = this.buildClassLoaderLookupStrategy(parentClassLoader, muleModules);
        return new MuleClassLoaderLookupPolicy(lookupStrategies, parentOnlyPackages);
    }

    protected ArtifactClassLoader createArtifactClassLoader(ClassLoader parentClassLoader, List<MuleModule> muleModules, ClassLoaderLookupPolicy containerLookupPolicy, ArtifactDescriptor artifactDescriptor) {
        return this.createContainerFilteringClassLoader(muleModules, (ArtifactClassLoader)new MuleContainerClassLoader(artifactDescriptor, new URL[0], parentClassLoader, containerLookupPolicy));
    }

    private Map<String, LookupStrategy> buildClassLoaderLookupStrategy(ClassLoader containerClassLoader, List<MuleModule> modules) {
        Preconditions.checkArgument((containerClassLoader != null ? 1 : 0) != 0, (String)"containerClassLoader cannot be null");
        Preconditions.checkArgument((modules != null ? 1 : 0) != 0, (String)"modules cannot be null");
        ContainerOnlyLookupStrategy containerOnlyLookupStrategy = new ContainerOnlyLookupStrategy(containerClassLoader);
        HashMap<String, LookupStrategy> result = new HashMap<String, LookupStrategy>();
        for (MuleModule muleModule : modules) {
            for (String exportedPackage : muleModule.getExportedPackages()) {
                result.put(exportedPackage, (LookupStrategy)(exportedPackage.startsWith("javax.") ? ParentFirstLookupStrategy.PARENT_FIRST : containerOnlyLookupStrategy));
            }
        }
        return result;
    }

    protected FilteringArtifactClassLoader createContainerFilteringClassLoader(List<MuleModule> muleModules, ArtifactClassLoader containerClassLoader) {
        return new FilteringContainerClassLoader(containerClassLoader, new ContainerClassLoaderFilterFactory().create(this.getBootPackages(), muleModules), this.getExportedServices(muleModules));
    }

    private List<ExportedService> getExportedServices(List<MuleModule> muleModules) {
        ArrayList<ExportedService> exportedServices = new ArrayList<ExportedService>();
        for (MuleModule muleModule : muleModules) {
            exportedServices.addAll(muleModule.getExportedServices());
        }
        return exportedServices;
    }

    protected Set<String> getBootPackages() {
        return BOOT_PACKAGES;
    }

    private static final class MuleContainerClassLoader
    extends MuleArtifactClassLoader {
        private MuleContainerClassLoader(ArtifactDescriptor artifactDescriptor, URL[] urls, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
            super("container", artifactDescriptor, urls, parent, lookupPolicy);
        }

        public URL findResource(String name) {
            return null;
        }

        public Enumeration<URL> findResources(String name) throws IOException {
            return new EnumerationAdapter(Collections.emptyList());
        }

        static {
            MuleContainerClassLoader.registerAsParallelCapable();
        }
    }
}

