/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.artifact.classloader;

import java.beans.Introspector;
import java.util.ResourceBundle;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.mule.module.artifact.classloader.ThreadGroupContextClassLoaderSoftReferenceBuster;
import org.mule.runtime.module.artifact.api.classloader.ResourceReleaser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderResourceReleaser
implements ResourceReleaser {
    private static final boolean IS_JAVA_VERSION_AT_MOST_11 = SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11);
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ClassLoader classLoader;

    public ClassLoaderResourceReleaser(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void release() {
        this.cleanUpResourceBundle();
        this.clearClassLoaderSoftkeys();
    }

    private void cleanUpResourceBundle() {
        try {
            ResourceBundle.clearCache(this.classLoader);
        }
        catch (Exception e) {
            this.logger.warn("Couldn't clean up ResourceBundle. This can cause a memory leak.", (Throwable)e);
        }
    }

    private void clearClassLoaderSoftkeys() {
        try {
            Introspector.flushCaches();
            if (IS_JAVA_VERSION_AT_MOST_11) {
                ThreadGroupContextClassLoaderSoftReferenceBuster.bustSoftReferences(this.classLoader);
            }
        }
        catch (Exception e) {
            this.logger.warn("Couldn't clear soft keys in caches. This can cause a classloader memory leak.", (Throwable)e);
        }
    }
}

