/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java.api;

import java.lang.reflect.Type;
import java.util.Optional;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.handler.DefaultTypeHandlerManagerFactory;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.handler.TypeHandlerManagerFactory;
import org.mule.metadata.java.api.utils.ClassUtils;
import org.mule.metadata.java.api.utils.ParsingContext;

public class JavaTypeLoader
implements ClassTypeLoader {
    public static MetadataFormat JAVA = MetadataFormat.JAVA;
    private final ClassLoader classLoader;
    private final TypeHandlerManagerFactory typeHandlerManagerFactory;

    public JavaTypeLoader(ClassLoader classLoader) {
        this(classLoader, new DefaultTypeHandlerManagerFactory());
    }

    public JavaTypeLoader(ClassLoader classLoader, TypeHandlerManagerFactory typeHandlerManagerFactory) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classloader cannot be null");
        }
        if (typeHandlerManagerFactory == null) {
            throw new IllegalArgumentException("typeHandlerManagerFactory cannot be null");
        }
        this.classLoader = classLoader;
        this.typeHandlerManagerFactory = typeHandlerManagerFactory;
    }

    public Optional<MetadataType> load(String identifier) {
        return this.load(identifier, null);
    }

    public Optional<MetadataType> load(String identifier, String typeAlias) {
        Class<?> clazz;
        if (Void.TYPE.getName().equals(identifier) || Void.class.getName().equals(identifier)) {
            return Optional.of(this.createTypeBuilder().voidType().build());
        }
        try {
            clazz = this.classLoader.loadClass(identifier);
        }
        catch (ClassNotFoundException e) {
            try {
                clazz = this.classLoader.loadClass(ClassUtils.getInnerClassName(identifier));
            }
            catch (ClassNotFoundException innerClassNotFound) {
                return Optional.empty();
            }
        }
        return Optional.of(this.load(clazz, typeAlias));
    }

    public MetadataType load(Type type) {
        return this.load(type, null);
    }

    public MetadataType load(Type type, String typeAlias) {
        BaseTypeBuilder typeBuilder = this.createTypeBuilder();
        if (Void.TYPE.equals(type) || Void.class.equals((Object)type)) {
            return typeBuilder.voidType().build();
        }
        TypeHandlerManager typeHandlerManager = this.typeHandlerManagerFactory.createTypeHandlerManager();
        typeHandlerManager.handle(type, new ParsingContext(), typeBuilder);
        MetadataTypeUtils.addTypeAlias((TypeBuilder)typeBuilder, (String)typeAlias);
        return typeBuilder.build();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private BaseTypeBuilder createTypeBuilder() {
        return BaseTypeBuilder.create((MetadataFormat)JAVA);
    }
}

