/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.ast.internal;

import java.util.List;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import org.mule.metadata.api.annotation.LengthAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.ast.api.IntrospectionContext;
import org.mule.metadata.ast.api.ObjectFieldHandler;
import org.mule.metadata.ast.api.TypeHandler;
import org.mule.metadata.ast.internal.ASTHelper;
import org.mule.metadata.ast.internal.ClassInformationAnnotationFactory;

public final class TypeMirrorLoaderVisitor
implements TypeVisitor<TypeBuilder<?>, IntrospectionContext> {
    private final ASTHelper astHelper;
    private final ProcessingEnvironment processingEnvironment;
    private final List<TypeHandler> handlers;
    private final TypeMirror objectType;
    private final ObjectFieldHandler objectFieldHandler;
    private final Types typeUtils;

    public TypeMirrorLoaderVisitor(ProcessingEnvironment processingEnvironment, List<TypeHandler> handlers, ObjectFieldHandler objectFieldHandler) {
        this.processingEnvironment = processingEnvironment;
        this.handlers = handlers;
        this.objectType = processingEnvironment.getElementUtils().getTypeElement(Object.class.getCanonicalName()).asType();
        this.astHelper = new ASTHelper(processingEnvironment);
        this.objectFieldHandler = objectFieldHandler;
        this.typeUtils = processingEnvironment.getTypeUtils();
    }

    @Override
    public TypeBuilder<?> visit(TypeMirror t, IntrospectionContext s) {
        return null;
    }

    @Override
    public TypeBuilder<?> visit(TypeMirror t) {
        return null;
    }

    @Override
    public TypeBuilder<?> visitPrimitive(PrimitiveType t, IntrospectionContext s) {
        switch (t.getKind()) {
            case LONG: {
                return this.builder().numberType().with((TypeAnnotation)ClassInformationAnnotationFactory.fromTypeMirror(t, this.processingEnvironment)).integer();
            }
            case INT: {
                return this.builder().numberType().with((TypeAnnotation)ClassInformationAnnotationFactory.fromTypeMirror(t, this.processingEnvironment)).integer();
            }
            case SHORT: {
                return this.builder().numberType().with((TypeAnnotation)ClassInformationAnnotationFactory.fromTypeMirror(t, this.processingEnvironment));
            }
            case DOUBLE: {
                return this.builder().numberType().with((TypeAnnotation)ClassInformationAnnotationFactory.fromTypeMirror(t, this.processingEnvironment));
            }
            case FLOAT: {
                return this.builder().numberType().with((TypeAnnotation)ClassInformationAnnotationFactory.fromTypeMirror(t, this.processingEnvironment));
            }
            case CHAR: {
                return this.builder().stringType().with((TypeAnnotation)ClassInformationAnnotationFactory.fromTypeMirror(t, this.processingEnvironment)).with((TypeAnnotation)new LengthAnnotation((Number)1, (Number)1));
            }
            case VOID: {
                return this.builder().voidType();
            }
            case NULL: {
                return this.builder().nullType();
            }
            case BYTE: {
                return this.builder().numberType().with((TypeAnnotation)ClassInformationAnnotationFactory.fromTypeMirror(t, this.processingEnvironment));
            }
            case BOOLEAN: {
                return this.builder().booleanType().id(Boolean.TYPE.getTypeName());
            }
        }
        throw new IllegalArgumentException("Unknown Primitive Type " + t);
    }

    @Override
    public TypeBuilder<?> visitNull(NullType t, IntrospectionContext s) {
        return this.builder().nullType();
    }

    @Override
    public TypeBuilder<?> visitArray(ArrayType t, IntrospectionContext s) {
        if (this.astHelper.isAssignable(t, Byte[].class, byte[].class)) {
            return this.builder().binaryType().with((TypeAnnotation)ClassInformationAnnotationFactory.fromTypeMirror(t, this.processingEnvironment));
        }
        return this.builder().arrayType().of((TypeBuilder)t.getComponentType().accept(this, s)).with((TypeAnnotation)ClassInformationAnnotationFactory.fromTypeMirror(t, this.processingEnvironment));
    }

    @Override
    public TypeBuilder<?> visitDeclared(DeclaredType t, IntrospectionContext context) {
        for (TypeHandler handler : this.handlers) {
            if (!handler.handles(t)) continue;
            return handler.handle(t, this, context);
        }
        Element element = t.asElement();
        if (context.contains(element)) {
            return context.get(element);
        }
        ObjectTypeBuilder objectTypeBuilder = this.builder().objectType().id(ASTHelper.typeId(t)).with((TypeAnnotation)ClassInformationAnnotationFactory.fromTypeMirror(t, this.processingEnvironment));
        this.extractJavadoc(this.processingEnvironment, element).ifPresent(arg_0 -> ((ObjectTypeBuilder)objectTypeBuilder).description(arg_0));
        context.push(element, (TypeBuilder)objectTypeBuilder);
        if (!this.typeUtils.isSameType(t, this.objectType)) {
            this.objectFieldHandler.handle(element, objectTypeBuilder, context, this);
        }
        context.pop();
        return objectTypeBuilder;
    }

    private Optional<String> extractJavadoc(ProcessingEnvironment processingEnv, Element element) {
        String comment = processingEnv.getElementUtils().getDocComment(element);
        if (comment == null || comment.trim().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(comment.trim().replaceAll("\\{@[^ ]+ ([^\\}]+)\\}", "$1"));
    }

    private BaseTypeBuilder builder() {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
    }

    @Override
    public TypeBuilder<?> visitError(ErrorType t, IntrospectionContext s) {
        return null;
    }

    @Override
    public TypeBuilder<?> visitTypeVariable(TypeVariable t, IntrospectionContext s) {
        if (!t.getLowerBound().equals(this.typeUtils.getNullType())) {
            return (TypeBuilder)t.getLowerBound().accept(this, s);
        }
        if (!t.getUpperBound().equals(this.typeUtils.getNullType())) {
            return (TypeBuilder)t.getUpperBound().accept(this, s);
        }
        return (TypeBuilder)this.objectType.accept(this, s);
    }

    @Override
    public TypeBuilder<?> visitWildcard(WildcardType t, IntrospectionContext s) {
        if (t.getExtendsBound() != null) {
            return (TypeBuilder)t.getExtendsBound().accept(this, s);
        }
        if (t.getSuperBound() != null) {
            return (TypeBuilder)t.getSuperBound().accept(this, s);
        }
        return (TypeBuilder)this.objectType.accept(this, s);
    }

    @Override
    public TypeBuilder<?> visitExecutable(ExecutableType t, IntrospectionContext s) {
        return null;
    }

    @Override
    public TypeBuilder<?> visitNoType(NoType t, IntrospectionContext s) {
        return this.builder().voidType();
    }

    @Override
    public TypeBuilder<?> visitUnknown(TypeMirror t, IntrospectionContext s) {
        return this.builder().voidType();
    }

    @Override
    public TypeBuilder<?> visitUnion(UnionType t, IntrospectionContext s) {
        return this.builder().anyType();
    }

    @Override
    public TypeBuilder<?> visitIntersection(IntersectionType t, IntrospectionContext s) {
        return this.builder().anyType();
    }
}

