/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.ast.internal.handler;

import java.math.BigInteger;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.ast.api.IntrospectionContext;
import org.mule.metadata.ast.internal.ClassInformationAnnotationFactory;
import org.mule.metadata.ast.internal.handler.BaseTypeHandler;

public class NumberTypeHandler
extends BaseTypeHandler {
    public NumberTypeHandler(ProcessingEnvironment processingEnvironment) {
        super(processingEnvironment, Number.class, BigInteger.class, Integer.class, Long.class, Byte.class);
    }

    @Override
    public TypeBuilder<?> handle(TypeMirror typeMirror, TypeVisitor<TypeBuilder<?>, IntrospectionContext> visitor, IntrospectionContext context) {
        if (this.astHelper.isAssignable(typeMirror, Number.class)) {
            NumberTypeBuilder numberTypeBuilder = this.builder().numberType().with((TypeAnnotation)ClassInformationAnnotationFactory.fromTypeMirror(typeMirror, this.processingEnvironment));
            if (this.astHelper.isAssignable(typeMirror, BigInteger.class, Integer.class, Long.class)) {
                return numberTypeBuilder.integer();
            }
            return numberTypeBuilder;
        }
        throw new IllegalArgumentException("The given TypeMirror is not handleable. " + typeMirror);
    }
}

