/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.annotation;

import java.util.Objects;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.utils.MetadataTypeUtils;

public class LengthAnnotation
implements TypeAnnotation {
    public static final String NAME = "length";
    private final Number min;
    private final Number max;

    public LengthAnnotation(Number min, Number max) {
        this.min = min;
        this.max = max;
    }

    public Optional<? extends Number> getMin() {
        return Optional.ofNullable(this.min);
    }

    public Optional<? extends Number> getMax() {
        return Optional.ofNullable(this.max);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LengthAnnotation) {
            LengthAnnotation other = (LengthAnnotation)obj;
            return Objects.equals(this.getMin(), other.getMin()) && Objects.equals(this.getMax(), other.getMax());
        }
        return false;
    }

    public int hashCode() {
        return MetadataTypeUtils.hashCode(this.getMin(), this.getMax());
    }
}

