/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

public class DefaultObjectType
extends BaseMetadataType
implements ObjectType {
    private final Collection<ObjectFieldType> fields;
    private final boolean ordered;
    private final MetadataType openRestriction;
    private Object[] fieldValues;

    public DefaultObjectType(Collection<ObjectFieldType> fields, boolean ordered, MetadataType openRestriction, MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        super(metadataFormat, extensions);
        this.fields = fields;
        this.ordered = ordered;
        this.openRestriction = openRestriction;
    }

    @Override
    public boolean isOrdered() {
        return this.ordered;
    }

    @Override
    public Optional<MetadataType> getOpenRestriction() {
        return Optional.ofNullable(this.openRestriction);
    }

    @Override
    public Collection<ObjectFieldType> getFields() {
        return this.fields;
    }

    @Override
    public Object[] getFieldValues() {
        if (this.fieldValues == null) {
            this.fieldValues = this.createFieldValuesArray();
        }
        return this.fieldValues;
    }

    private Object[] createFieldValuesArray() {
        ArrayList fieldValues = new ArrayList();
        Collections.addAll(fieldValues, super.getFieldValues());
        Collections.addAll(fieldValues, this.fields, this.ordered, this.openRestriction);
        return fieldValues.toArray(new Object[fieldValues.size()]);
    }

    @Override
    public Optional<ObjectFieldType> getFieldByName(String propertyName) {
        return this.fields.stream().filter(propertyType -> {
            ObjectKeyType key = propertyType.getKey();
            return key.isName() && key.getName().getLocalPart().equals(propertyName);
        }).findFirst();
    }

    @Override
    public void accept(MetadataTypeVisitor visitor) {
        visitor.visitObject(this);
    }

    @Override
    public String toString() {
        return MetadataTypeUtils.getTypeId(this).orElseGet(() -> super.toString());
    }
}

