/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.soap;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.soap.WebServiceDefinition;

public class WebServiceDefinitionBuilder {
    private String serviceId;
    private String friendlyName;
    private URL wsdlUrl;
    private URL address;
    private String service;
    private String port;
    private List<String> excludedOperations = Collections.emptyList();

    WebServiceDefinitionBuilder() {
    }

    public WebServiceDefinitionBuilder withId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public WebServiceDefinitionBuilder withFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public WebServiceDefinitionBuilder withWsdlUrl(URL wsdlUrl) {
        this.wsdlUrl = wsdlUrl;
        return this;
    }

    public WebServiceDefinitionBuilder withAddress(URL address) {
        this.address = address;
        return this;
    }

    public WebServiceDefinitionBuilder withWsdlUrl(String wsdlUrl) {
        try {
            this.wsdlUrl = new URL(wsdlUrl);
            return this;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("the provided WSDL URL is not a well formed URL: [" + wsdlUrl + "]", e);
        }
    }

    public WebServiceDefinitionBuilder withAddress(String address) {
        try {
            this.address = new URL(address);
            return this;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("the provided address is not a well formed URL: [" + address + "]", e);
        }
    }

    public WebServiceDefinitionBuilder withService(String service) {
        this.service = service;
        return this;
    }

    public WebServiceDefinitionBuilder withPort(String port) {
        this.port = port;
        return this;
    }

    public WebServiceDefinitionBuilder withExcludedOperations(List<String> excludedOperations) {
        this.excludedOperations = excludedOperations;
        return this;
    }

    public WebServiceDefinition build() {
        Preconditions.checkNotNull((Object)this.serviceId, (String)"ID cannot be null");
        Preconditions.checkNotNull((Object)this.wsdlUrl, (String)"WSDL Url cannot be null");
        Preconditions.checkNotNull((Object)this.service, (String)"Service cannot be null");
        Preconditions.checkNotNull((Object)this.port, (String)"Port Url cannot be null");
        return new WebServiceDefinition(this.serviceId, this.friendlyName, this.wsdlUrl, this.address, this.service, this.port, this.excludedOperations);
    }
}

