/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.values;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.value.Value;

@NoExtend
public class ImmutableValue
implements Value {
    private final String id;
    private final String displayName;
    private final String partName;
    private final Set<Value> childs;

    ImmutableValue(String id, String displayName, Set<Value> childs, String partName) {
        this.id = id;
        this.displayName = displayName;
        this.childs = childs;
        this.partName = partName;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Set<Value> getChilds() {
        return Collections.unmodifiableSet(this.childs);
    }

    public String getPartName() {
        return this.partName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableValue that = (ImmutableValue)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.partName, that.partName) && Objects.equals(this.childs, that.childs);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.displayName, this.partName, this.childs);
    }

    public String toString() {
        return "{id:'" + this.id + '\'' + ", displayName:'" + this.displayName + '\'' + ", partName:'" + this.partName + '\'' + ", childs:" + this.childs + '}';
    }
}

