/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;

public final class ExecutionTypeDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.POST_STRUCTURE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new IdempotentDeclarationWalker(){

            @Override
            protected void onOperation(OperationDeclaration declaration) {
                declaration.setExecutionType(ExecutionTypeDeclarationEnricher.this.resolve(declaration));
            }
        }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private ExecutionType resolve(OperationDeclaration declaration) {
        ExecutionType executionType = declaration.getExecutionType();
        if (executionType != null) {
            return executionType;
        }
        if (declaration.isRequiresConnection()) {
            return declaration.isBlocking() ? ExecutionType.BLOCKING : ExecutionType.CPU_LITE;
        }
        return ExecutionType.CPU_LITE;
    }
}

