/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.util.DeclarationWalker;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.NoImplicitModelProperty;
import org.mule.runtime.extension.api.property.SyntheticModelModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.internal.util.ExtensionNamespaceUtils;
import org.mule.sdk.api.stereotype.MuleStereotypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigRefDeclarationEnricher
implements DeclarationEnricher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigRefDeclarationEnricher.class);
    private static final String CONFIG_REF_NAME = "config-ref";
    private static final MetadataType CONFIG_TYPE = ConfigRefDeclarationEnricher.buildConfigRefType();

    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ExtensionDeclaration declaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
        Multimap<ComponentDeclaration, ConfigurationDeclaration> componentsConfigs = this.getComponentConfigsMap(declaration);
        componentsConfigs.asMap().forEach((component, configs) -> {
            if ("APIKit".equals(declaration.getName()) && component.getDefaultParameterGroup().getParameters().stream().anyMatch(param -> param.getName().equals(CONFIG_REF_NAME))) {
                LOGGER.warn("Component '" + component.getName() + "' in extension '" + declaration.getName() + "' already has a '" + CONFIG_REF_NAME + "' parameter defined. Skipping ConfigRefDeclarationEnricher for it.");
                return;
            }
            component.getDefaultParameterGroup().addParameter(this.buildConfigRefParameter((Collection<ConfigurationDeclaration>)configs));
        });
    }

    private Multimap<ComponentDeclaration, ConfigurationDeclaration> getComponentConfigsMap(ExtensionDeclaration declaration) {
        String namespace = ExtensionNamespaceUtils.getExtensionsNamespace(declaration);
        LinkedListMultimap componentConfigs = LinkedListMultimap.create();
        new DeclarationWalker((Multimap)componentConfigs, namespace){
            final /* synthetic */ Multimap val$componentConfigs;
            final /* synthetic */ String val$namespace;
            {
                this.val$componentConfigs = multimap;
                this.val$namespace = string;
            }

            protected void onConfiguration(ConfigurationDeclaration config) {
                config.getConstructs().forEach(construct -> this.val$componentConfigs.put(construct, (Object)config));
                config.getMessageSources().forEach(source -> this.val$componentConfigs.put(source, (Object)config));
                config.getOperations().forEach(operation -> this.val$componentConfigs.put(operation, (Object)config));
                if (config.getStereotype() == null) {
                    config.withStereotype(StereotypeModelBuilder.newStereotype((String)config.getName(), (String)this.val$namespace).withParent(MuleStereotypes.CONFIG).build());
                }
            }
        }.walk(declaration);
        return componentConfigs;
    }

    private ParameterDeclaration buildConfigRefParameter(Collection<ConfigurationDeclaration> configs) {
        ParameterDeclaration parameter = new ParameterDeclaration(CONFIG_REF_NAME);
        parameter.setDescription("The name of the configuration to be used to execute this component");
        parameter.setRequired(!this.hasAnImplicitConfig(configs));
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.addModelProperty((ModelProperty)new SyntheticModelModelProperty());
        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsReferences(true).build());
        parameter.setType(CONFIG_TYPE, false);
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setAllowedStereotypeModels(this.collectStereotypes(configs));
        return parameter;
    }

    private List<StereotypeModel> collectStereotypes(Collection<ConfigurationDeclaration> configs) {
        return configs.stream().map(c -> c.getStereotype()).collect(Collectors.toList());
    }

    private boolean hasAnImplicitConfig(Collection<ConfigurationDeclaration> configs) {
        List implicitConfigs = configs.stream().filter(this::canBeUsedImplicitly).collect(Collectors.toList());
        return implicitConfigs.stream().anyMatch(config -> {
            List providers = config.getConnectionProviders();
            return providers.isEmpty() || providers.stream().anyMatch(this::canBeUsedImplicitly);
        });
    }

    private boolean canBeUsedImplicitly(ParameterizedDeclaration<?> parameterized) {
        if (parameterized.getModelProperty(NoImplicitModelProperty.class).isPresent()) {
            return false;
        }
        return parameterized.getAllParameters().stream().noneMatch(ParameterDeclaration::isRequired);
    }

    private static MetadataType buildConfigRefType() {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().id(ConfigurationProvider.class.getName()).with((TypeAnnotation)new ClassInformationAnnotation(ConfigurationProvider.class)).build();
    }
}

