/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthParameterModelProperty;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterDslAnnotation;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resolver.SingleExtensionImportTypesStrategy;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;

public final class ParameterModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel model, ProblemsReporter problemsReporter) {
        new ValidatorDelegate().validate(model, problemsReporter);
    }

    private class ValidatorDelegate
    implements ExtensionModelValidator {
        private TypeCatalog typeCatalog;
        private DslSyntaxResolver dsl;

        private ValidatorDelegate() {
        }

        @Override
        public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
            this.typeCatalog = TypeCatalog.getDefault(Collections.singleton(extensionModel));
            this.dsl = DslSyntaxResolver.getDefault(extensionModel, new SingleExtensionImportTypesStrategy());
            new ExtensionWalker(){

                public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                    String ownerName = owner.getName();
                    String ownerModelType = NameUtils.getComponentModelTypeName(owner);
                    ValidatorDelegate.this.validateParameter(model, ownerName, ownerModelType, problemsReporter);
                    ValidatorDelegate.this.validateOAuthParameter(model, ownerName, ownerModelType, problemsReporter);
                    ValidatorDelegate.this.validateNameCollisionWithTypes(model, ownerName, ownerModelType, owner.getAllParameterModels().stream().map(p -> NameUtils.hyphenize((String)p.getName())).collect(Collectors.toList()), problemsReporter);
                }
            }.walk(extensionModel);
        }

        private void validateParameter(final ParameterModel parameterModel, String ownerName, String ownerModelType, final ProblemsReporter problemsReporter) {
            if (parameterModel.getType() == null) {
                problemsReporter.addError(new Problem((NamedObject)parameterModel, String.format("Parameter '%s' in the %s '%s' must provide a type", parameterModel.getName(), ownerModelType, ownerName)));
            }
            if (parameterModel.getDefaultValue() != null) {
                if (parameterModel.isOverrideFromConfig() && !ownerModelType.equals("configuration") && !ownerModelType.equals("connection provider")) {
                    problemsReporter.addError(new Problem((NamedObject)parameterModel, String.format("Parameter '%s' in the %s '%s' is declared as a config override, and must not provide a default value since one is already provided by the declared value in the config parameter", parameterModel.getName(), ownerModelType, ownerName)));
                } else if (parameterModel.isRequired()) {
                    problemsReporter.addError(new Problem((NamedObject)parameterModel, String.format("Parameter '%s' in the %s '%s' is required, and must not provide a default value", parameterModel.getName(), ownerModelType, ownerName)));
                }
            }
            if (parameterModel.getType() == null) {
                problemsReporter.addError(new Problem((NamedObject)parameterModel, String.format("Parameter '%s' in the %s '%s' doesn't specify a return type", parameterModel.getName(), ownerModelType, ownerName)));
            } else {
                parameterModel.getType().accept(new MetadataTypeVisitor(){
                    private Set<MetadataType> visitedTypes = new HashSet<MetadataType>();

                    public void visitUnion(UnionType unionType) {
                        unionType.getTypes().forEach(t -> t.accept((MetadataTypeVisitor)this));
                    }

                    public void visitArrayType(ArrayType arrayType) {
                        arrayType.getType().accept((MetadataTypeVisitor)this);
                    }

                    public void visitObject(ObjectType objectType) {
                        DslElementSyntax paramDsl = ValidatorDelegate.this.dsl.resolve(parameterModel);
                        if (objectType.isOpen()) {
                            ((MetadataType)objectType.getOpenRestriction().get()).accept((MetadataTypeVisitor)this);
                        } else if ((paramDsl.supportsTopLevelDeclaration() || paramDsl.supportsChildDeclaration()) && this.visitedTypes.add((MetadataType)objectType)) {
                            for (ObjectFieldType field : objectType.getFields()) {
                                if (ValidatorDelegate.this.supportsGlobalReferences(field)) {
                                    field.getValue().accept((MetadataTypeVisitor)this);
                                }
                                ExtensionMetadataTypeUtils.getType(field.getValue()).filter(c -> c.getAnnotation(ConfigOverride.class) != null).ifPresent(c -> problemsReporter.addError(new Problem((NamedObject)parameterModel, String.format("Type '%s' has fields declared as '%s', which is not allowed.", ExtensionMetadataTypeUtils.getId((MetadataType)objectType).get(), ConfigOverride.class.getSimpleName()))));
                            }
                        }
                    }
                });
            }
        }

        private void validateNameCollisionWithTypes(ParameterModel parameterModel, String ownerName, String ownerModelType, List<String> parameterNames, ProblemsReporter problemsReporter) {
            if (parameterModel.getType() instanceof ObjectType) {
                this.typeCatalog.getSubTypes((ObjectType)parameterModel.getType()).stream().filter(subtype -> parameterNames.contains(NameUtils.getTopLevelTypeName((MetadataType)subtype))).findFirst().ifPresent(metadataType -> problemsReporter.addError(new Problem((NamedObject)parameterModel, String.format("Parameter '%s' in the %s [%s] can't have the same name as the ClassName or Alias of the declared subType [%s] for parameter [%s]", NameUtils.getTopLevelTypeName((MetadataType)metadataType), ownerModelType, ownerName, ExtensionMetadataTypeUtils.getId((MetadataType)metadataType), parameterModel.getName()))));
            }
        }

        private boolean supportsGlobalReferences(ObjectFieldType field) {
            return this.dsl.resolve(field.getValue()).map(DslElementSyntax::supportsTopLevelDeclaration).orElseGet(() -> field.getAnnotation(ParameterDslAnnotation.class).map(ParameterDslAnnotation::allowsReferences).orElse(true));
        }

        private void validateOAuthParameter(ParameterModel parameterModel, String ownerName, String ownerModelType, ProblemsReporter problemsReporter) {
            parameterModel.getModelProperty(OAuthParameterModelProperty.class).ifPresent(p -> {
                if (parameterModel.getExpressionSupport() != ExpressionSupport.NOT_SUPPORTED) {
                    problemsReporter.addError(new Problem((NamedObject)parameterModel, String.format("Parameter '%s' in the %s [%s] is an OAuth parameter yet it supports expressions. Expressions are not supported on OAuth parameters", parameterModel.getName(), ownerModelType, ownerName)));
                }
                if (!ExtensionMetadataTypeUtils.isBasic(parameterModel.getType())) {
                    problemsReporter.addError(new Problem((NamedObject)parameterModel, String.format("Parameter '%s' in the %s [%s] is an OAuth parameter but is a %s. Only basic types are supported on OAuth parameters", parameterModel.getName(), ownerModelType, ownerName, parameterModel.getType().getClass().getSimpleName())));
                }
            });
        }
    }
}

