/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;

public final class SubtypesModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel model, ProblemsReporter problemsReporter) {
        Map<ObjectType, Set<ObjectType>> typesMapping = ExtensionModelUtils.toSubTypesMap(model.getSubTypes());
        this.validateBaseTypeNotFinal(model, typesMapping, problemsReporter);
        this.validateSubtypesExtendOrImplementBaseType(model, typesMapping, problemsReporter);
        this.validateSubtypesNameClashing(model, typesMapping, problemsReporter);
    }

    private void validateBaseTypeNotFinal(ExtensionModel model, Map<ObjectType, Set<ObjectType>> typesMapping, ProblemsReporter problemsReporter) {
        List finalBaseTypes = typesMapping.keySet().stream().filter(ExtensionMetadataTypeUtils::isFinal).map(type -> ExtensionMetadataTypeUtils.getId((MetadataType)type).orElse(null)).filter(type -> type != null).collect(Collectors.toList());
        if (!finalBaseTypes.isEmpty()) {
            problemsReporter.addError(new Problem((NamedObject)model, String.format("All the declared SubtypesMapping should have non final base types, but [%s] are final", Arrays.toString(finalBaseTypes.toArray()))));
        }
    }

    private void validateSubtypesExtendOrImplementBaseType(ExtensionModel model, Map<ObjectType, Set<ObjectType>> typesMapping, ProblemsReporter problemsReporter) {
        for (Map.Entry<ObjectType, Set<ObjectType>> subtypes : typesMapping.entrySet()) {
            List invalidTypes;
            Optional baseType = ExtensionMetadataTypeUtils.getType((MetadataType)subtypes.getKey());
            if (!baseType.isPresent() || (invalidTypes = subtypes.getValue().stream().map(ExtensionMetadataTypeUtils::getType).filter(Optional::isPresent).map(Optional::get).filter(s -> !((Class)baseType.get()).isAssignableFrom((Class<?>)s)).map(Class::getSimpleName).collect(Collectors.toList())).isEmpty()) continue;
            problemsReporter.addError(new Problem((NamedObject)model, String.format("All the declared Subtypes should be concrete implementations of the give baseType, but [%s] are not implementations of [%s]", Arrays.toString(invalidTypes.toArray()), baseType.get().getSimpleName())));
        }
    }

    private void validateSubtypesNameClashing(ExtensionModel model, Map<ObjectType, Set<ObjectType>> typesMapping, ProblemsReporter problemsReporter) {
        ImmutableList mappedTypes = ImmutableList.builder().addAll(typesMapping.keySet()).addAll((Iterable)typesMapping.values().stream().flatMap(Collection::stream).collect(Collectors.toList())).build();
        HashMap<String, MetadataType> typesByName = new HashMap<String, MetadataType>();
        for (MetadataType type : mappedTypes) {
            MetadataType previousType = typesByName.put(NameUtils.getTopLevelTypeName(type), type);
            if (previousType == null || previousType.equals(type)) continue;
            problemsReporter.addError(new Problem((NamedObject)model, String.format("Subtypes mapped Type [%s] with alias [%s] in extension [%s] should have a different alias name than the previous mapped type [%s]", ExtensionMetadataTypeUtils.getAlias(type), NameUtils.getTopLevelTypeName(type), model.getName(), ExtensionMetadataTypeUtils.getAlias(previousType))));
        }
    }
}

