/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.dsl.syntax.resolver;

import java.util.Map;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.extension.api.dsl.syntax.resolver.ImportTypesStrategy;

public class DefaultImportTypesStrategy
implements ImportTypesStrategy {
    private final ExtensionModel extensionModel;
    private final DslResolvingContext context;

    public DefaultImportTypesStrategy(ExtensionModel extensionModel, DslResolvingContext context) {
        this.extensionModel = extensionModel;
        this.context = context;
    }

    @Override
    public Map<MetadataType, XmlDslModel> getImportedTypes() {
        return this.extensionModel.getImportedTypes().stream().collect(Collectors.toMap(ImportedTypeModel::getImportedType, imported -> {
            ExtensionModel extensionModel = (ExtensionModel)this.context.getExtension(imported.getOriginExtensionName()).orElseThrow(() -> new IllegalArgumentException(String.format("The Extension [%s] is not present in the current context", imported.getOriginExtensionName())));
            return extensionModel.getXmlDslModel();
        }));
    }
}

