/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.operation.RouterModel;
import org.mule.runtime.api.meta.model.operation.ScopeModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ComponentModelVisitor;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.model.operation.ImmutableRouterModel;
import org.mule.runtime.extension.api.model.operation.ImmutableScopeModel;

public class OperationModelTypeAdapter
extends TypeAdapter<OperationModel> {
    private static final String KIND = "kind";
    private static final String OPERATION_KIND = "operation";
    private static final String SCOPE_KIND = "scope";
    private static final String ROUTER_KIND = "router";
    private final TypeAdapterFactory typeAdapterFactory;
    private final Gson gson;

    public OperationModelTypeAdapter(TypeAdapterFactory typeAdapterFactory, Gson gson) {
        this.typeAdapterFactory = typeAdapterFactory;
        this.gson = gson;
    }

    public void write(JsonWriter out, OperationModel value) throws IOException {
        JsonObject json = this.getDelegateAdapter(value).toJsonTree((Object)value).getAsJsonObject();
        final Reference kind = new Reference();
        value.accept(new ComponentModelVisitor(){

            public void visit(OperationModel operationModel) {
                kind.set((Object)OperationModelTypeAdapter.OPERATION_KIND);
            }

            public void visit(ScopeModel scopeModel) {
                kind.set((Object)OperationModelTypeAdapter.SCOPE_KIND);
            }

            public void visit(RouterModel routerModel) {
                kind.set((Object)OperationModelTypeAdapter.ROUTER_KIND);
            }

            public void visit(SourceModel sourceModel) {
            }
        });
        json.addProperty(KIND, (String)kind.get());
        this.gson.toJson((JsonElement)json, out);
    }

    public OperationModel read(JsonReader in) throws IOException {
        Class<ImmutableOperationModel> operationClass;
        JsonObject json = new JsonParser().parse(in).getAsJsonObject();
        if (!json.has(KIND)) {
            throw new IllegalArgumentException("Invalid json. Operation doesn't specify kind");
        }
        String kind = json.get(KIND).getAsString();
        if (OPERATION_KIND.equals(kind)) {
            operationClass = ImmutableOperationModel.class;
        } else if (SCOPE_KIND.equals(kind)) {
            operationClass = ImmutableScopeModel.class;
        } else if (ROUTER_KIND.equals(kind)) {
            operationClass = ImmutableRouterModel.class;
        } else {
            throw new IllegalArgumentException("Invalid json. Operation specifies unknown kind: " + kind);
        }
        return (OperationModel)this.gson.getDelegateAdapter(this.typeAdapterFactory, TypeToken.get(operationClass)).fromJsonTree((JsonElement)json);
    }

    private TypeAdapter<OperationModel> getDelegateAdapter(OperationModel value) {
        Class operationClass = value instanceof ScopeModel ? ImmutableScopeModel.class : (value instanceof RouterModel ? ImmutableRouterModel.class : ImmutableOperationModel.class);
        return this.gson.getDelegateAdapter(this.typeAdapterFactory, TypeToken.get(operationClass));
    }
}

