/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import com.vdurmont.semver4j.Semver;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.module.embedded.api.Product;

public class RuntimeProduct {
    private static final Semver SUPPORTS_NEW_IMPL_VERSION = new Semver("4.5.0");
    private static final Semver MULE_46_VERSION = new Semver("4.6.0");
    private final Product product;
    private final String version;
    private final boolean supportsNewImplementation;
    private final boolean is46OrGreater;

    public RuntimeProduct(Product product, String version) {
        this.product = product;
        this.version = version;
        Semver versionWithoutSuffix = new Semver(version).withClearedSuffix();
        boolean isMuleFramework = product.equals((Object)Product.MULE_FRAMEWORK);
        this.supportsNewImplementation = isMuleFramework || SUPPORTS_NEW_IMPL_VERSION.isLowerThanOrEqualTo(versionWithoutSuffix);
        this.is46OrGreater = isMuleFramework || MULE_46_VERSION.isLowerThanOrEqualTo(versionWithoutSuffix);
    }

    public boolean isSupportsNewImplementation() {
        return this.supportsNewImplementation;
    }

    public boolean isSupportsControllerApi() {
        return this.is46OrGreater;
    }

    public BundleDescriptor getContainerBomBundleDescriptor() {
        Product.ArtifactCoordinates containerBomArtifactCoordinates = this.getContainerBomArtifactCoordinates();
        return new BundleDescriptor.Builder().setGroupId(containerBomArtifactCoordinates.getGroupId()).setArtifactId(containerBomArtifactCoordinates.getArtifactId()).setVersion(this.version).setType("pom").build();
    }

    private Product.ArtifactCoordinates getContainerBomArtifactCoordinates() {
        return this.is46OrGreater ? this.product.getContainerBomArtifactCoordinates() : this.product.getDeprecatedBomArtifactCoordinates();
    }

    public BundleDescriptor getServicesBomBundleDescriptor() {
        Product.ArtifactCoordinates servicesBomArtifactCoordinates = this.getServicesBomArtifactCoordinates();
        return new BundleDescriptor.Builder().setGroupId(servicesBomArtifactCoordinates.getGroupId()).setArtifactId(servicesBomArtifactCoordinates.getArtifactId()).setVersion(this.version).setType("pom").build();
    }

    private Product.ArtifactCoordinates getServicesBomArtifactCoordinates() {
        return this.is46OrGreater ? this.product.getServicesBomArtifactCoordinates() : this.product.getDeprecatedBomArtifactCoordinates();
    }
}

