/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.plexus.util.FileUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.BundleScope;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.module.embedded.api.ApplicationConfiguration;
import org.mule.runtime.module.embedded.api.ContainerInfo;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.mule.runtime.module.embedded.api.Product;
import org.mule.runtime.module.embedded.internal.MavenContainerClassLoaderFactory;
import org.mule.runtime.module.embedded.internal.Serializer;
import org.mule.runtime.module.embedded.internal.classloading.FilteringClassLoader;
import org.mule.runtime.module.embedded.internal.classloading.JdkOnlyClassLoaderFactory;

public class DefaultEmbeddedContainerBuilder
implements EmbeddedContainer.EmbeddedContainerBuilder {
    private String muleVersion;
    private URL containerBaseFolder;
    private ApplicationConfiguration applicationConfiguration;
    private URI log4jConfigurationFile;
    private MavenConfiguration mavenConfiguration;
    private Product product = Product.MULE;

    @Override
    public EmbeddedContainer.EmbeddedContainerBuilder withMuleVersion(String muleVersion) {
        this.muleVersion = muleVersion;
        return this;
    }

    @Override
    public EmbeddedContainer.EmbeddedContainerBuilder withProduct(Product product) {
        this.product = product;
        return this;
    }

    @Override
    public EmbeddedContainer.EmbeddedContainerBuilder withContainerBaseFolder(URL containerBaseFolder) {
        this.containerBaseFolder = containerBaseFolder;
        return this;
    }

    @Override
    public EmbeddedContainer.EmbeddedContainerBuilder withApplicationConfiguration(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
        return this;
    }

    @Override
    public EmbeddedContainer.EmbeddedContainerBuilder withLog4jConfigurationFile(URI log4JConfigurationFile) {
        this.log4jConfigurationFile = log4JConfigurationFile;
        return this;
    }

    @Override
    public EmbeddedContainer.EmbeddedContainerBuilder withMavenConfiguration(MavenConfiguration mavenConfiguration) {
        this.mavenConfiguration = mavenConfiguration;
        return this;
    }

    @Override
    public EmbeddedContainer build() {
        Preconditions.checkState((this.muleVersion != null ? 1 : 0) != 0, (Object)"muleVersion cannot be null");
        Preconditions.checkState((this.containerBaseFolder != null ? 1 : 0) != 0, (Object)"containerBaseFolder cannot be null");
        Preconditions.checkState((this.applicationConfiguration != null ? 1 : 0) != 0, (Object)"application cannot be null");
        Preconditions.checkState((this.mavenConfiguration != null ? 1 : 0) != 0, (Object)"mavenConfiguration cannot be null");
        try {
            if (this.log4jConfigurationFile != null) {
                this.configureLogging(this.getClass().getClassLoader());
            }
            FilteringClassLoader jdkOnlyClassLoader = JdkOnlyClassLoaderFactory.create();
            MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider((ClassLoader)this.getClass().getClassLoader());
            MavenClient mavenClient = mavenClientProvider.createMavenClient(this.mavenConfiguration);
            MavenContainerClassLoaderFactory classLoaderFactory = new MavenContainerClassLoaderFactory(mavenClient);
            final ClassLoader containerModulesClassLoader = classLoaderFactory.create(this.muleVersion, this.product, jdkOnlyClassLoader, this.containerBaseFolder);
            List<URL> services = classLoaderFactory.getServices(this.muleVersion, this.product);
            ContainerInfo containerInfo = new ContainerInfo(this.muleVersion, this.containerBaseFolder, services);
            if (this.mavenConfiguration != null) {
                this.persistMavenConfiguration(this.containerBaseFolder, this.mavenConfiguration);
            }
            ClassLoader embeddedControllerBootstrapClassLoader = DefaultEmbeddedContainerBuilder.createEmbeddedImplClassLoader(containerModulesClassLoader, mavenClient, this.muleVersion);
            try {
                Class<?> controllerClass = embeddedControllerBootstrapClassLoader.loadClass("org.mule.runtime.module.embedded.impl.EmbeddedController");
                Constructor<?> constructor = controllerClass.getConstructor(byte[].class, byte[].class);
                ByteArrayOutputStream containerOutputStream = new ByteArrayOutputStream(512);
                Serializer.serialize(containerInfo, containerOutputStream);
                ByteArrayOutputStream appConfigOutputStream = new ByteArrayOutputStream(512);
                Serializer.serialize(this.applicationConfiguration, appConfigOutputStream);
                final Object embeddedController = constructor.newInstance(containerOutputStream.toByteArray(), appConfigOutputStream.toByteArray());
                return new EmbeddedContainer(){

                    @Override
                    public void start() {
                        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader(containerModulesClassLoader);
                            Method startMethod = embeddedController.getClass().getMethod("start", new Class[0]);
                            startMethod.invoke(embeddedController, new Object[0]);
                        }
                        catch (InvocationTargetException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof RuntimeException) {
                                throw (RuntimeException)cause;
                            }
                            throw new IllegalStateException(cause);
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(e);
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(contextClassLoader);
                        }
                    }

                    @Override
                    public void stop() {
                        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader(containerModulesClassLoader);
                            Method stopMethod = embeddedController.getClass().getMethod("stop", new Class[0]);
                            stopMethod.invoke(embeddedController, new Object[0]);
                        }
                        catch (InvocationTargetException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof RuntimeException) {
                                throw (RuntimeException)cause;
                            }
                            throw new IllegalStateException(cause);
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(e);
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(contextClassLoader);
                        }
                    }
                };
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot create embedded container", e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void configureLogging(ClassLoader classLoader) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> log4jLogManagerClass = classLoader.loadClass("org.apache.logging.log4j.LogManager");
        Object logContext = log4jLogManagerClass.getMethod("getContext", Boolean.TYPE).invoke(null, false);
        Class<?> log4jLoggerContextClass = classLoader.loadClass("org.apache.logging.log4j.core.LoggerContext");
        log4jLoggerContextClass.getMethod("setConfigLocation", URI.class).invoke(logContext, this.log4jConfigurationFile);
    }

    private void persistMavenConfiguration(URL containerBaseFolder, MavenConfiguration mavenConfiguration) throws IOException {
        File configurationFolder = new File(FileUtils.toFile((URL)containerBaseFolder), "conf");
        if (!configurationFolder.exists() && !configurationFolder.mkdirs()) {
            throw new IllegalArgumentException("Could not create MULE_HOME/conf folder in: " + configurationFolder.getAbsolutePath());
        }
        JsonObject rootObject = new JsonObject();
        JsonObject muleRuntimeConfigObject = new JsonObject();
        rootObject.add("muleRuntimeConfig", (JsonElement)muleRuntimeConfigObject);
        JsonObject mavenObject = new JsonObject();
        muleRuntimeConfigObject.add("maven", (JsonElement)mavenObject);
        if (!mavenConfiguration.getMavenRemoteRepositories().isEmpty()) {
            JsonObject repositoriesObject = new JsonObject();
            mavenObject.add("repositories", (JsonElement)repositoriesObject);
            mavenConfiguration.getMavenRemoteRepositories().forEach(mavenRepo -> {
                JsonObject repoObject = new JsonObject();
                repositoriesObject.add(mavenRepo.getId(), (JsonElement)repoObject);
                repoObject.addProperty("url", mavenRepo.getUrl().toString());
                mavenRepo.getAuthentication().ifPresent(authentication -> {
                    repoObject.addProperty("username", authentication.getUsername());
                    repoObject.addProperty("password", authentication.getPassword());
                });
            });
        }
        mavenObject.addProperty("repositoryLocation", mavenConfiguration.getLocalMavenRepositoryLocation().getAbsolutePath());
        String muleConfigContent = new Gson().toJson((JsonElement)rootObject);
        FileUtils.fileWrite((File)new File(configurationFolder, "mule-config.json"), (String)muleConfigContent);
    }

    private static ClassLoader createEmbeddedImplClassLoader(ClassLoader parentClassLoader, MavenClient mavenClient, String muleVersion) throws MalformedURLException {
        BundleDescriptor embeddedControllerImplDescriptor = new BundleDescriptor.Builder().setGroupId("org.mule.distributions").setArtifactId("mule-module-embedded-impl").setVersion(muleVersion).setType("jar").build();
        BundleDependency embeddedBundleImplDependency = mavenClient.resolveBundleDescriptor(embeddedControllerImplDescriptor);
        List embeddedImplDependencies = mavenClient.resolveBundleDescriptorDependencies(false, embeddedControllerImplDescriptor);
        List<URL> embeddedUrls = embeddedImplDependencies.stream().filter(bundleDependency -> !bundleDependency.getScope().equals((Object)BundleScope.PROVIDED)).map(dep -> {
            try {
                return dep.getBundleUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        embeddedUrls.add(embeddedBundleImplDependency.getBundleUri().toURL());
        return new URLClassLoader(embeddedUrls.toArray(new URL[embeddedUrls.size()]), parentClassLoader);
    }
}

