/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.exception;

import java.util.Objects;
import org.mule.runtime.api.exception.MuleException;

public class SuppressedMuleException
extends MuleException {
    private static final long serialVersionUID = -2020531237382360468L;
    private final MuleException suppressedException;

    private SuppressedMuleException(Throwable throwable, MuleException causeToSuppress) {
        super(Objects.requireNonNull(throwable, "Exception cannot be null"));
        this.suppressedException = Objects.requireNonNull(causeToSuppress, "Cannot suppress a null cause");
        this.addSuppressionToMuleExceptionInfo(causeToSuppress);
    }

    private void addSuppressionToMuleExceptionInfo(MuleException causeToSuppress) {
        this.getExceptionInfo().addSuppressedCause(causeToSuppress);
        this.addAllInfo(causeToSuppress.getAdditionalInfo());
        Throwable nestedCause = causeToSuppress;
        while (nestedCause.getCause() != null && nestedCause.getCause() != nestedCause) {
            if (!((nestedCause = nestedCause.getCause()) instanceof MuleException)) continue;
            this.addAllInfo(((MuleException)nestedCause).getAdditionalInfo());
            if (!(nestedCause instanceof SuppressedMuleException)) continue;
            this.getExceptionInfo().addSuppressedCause(((SuppressedMuleException)nestedCause).getSuppressedException());
        }
    }

    public Throwable unwrap() {
        return this.getCause();
    }

    public MuleException getSuppressedException() {
        return this.suppressedException;
    }

    public static Throwable suppressIfPresent(Throwable exception, Class<? extends MuleException> causeToSuppress) {
        for (Throwable cause = exception; cause != null && !(cause instanceof SuppressedMuleException); cause = cause.getCause()) {
            if (causeToSuppress.isInstance(cause)) {
                return new SuppressedMuleException(exception, (MuleException)cause);
            }
            if (cause.getCause() == cause) break;
        }
        return exception;
    }
}

