/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataProperty;

public final class DefaultMetadataKey
implements MetadataKey {
    private final String id;
    private final String displayName;
    private final String partName;
    private final Map<Class<? extends MetadataProperty>, MetadataProperty> properties;
    private final Set<MetadataKey> childs;

    protected DefaultMetadataKey(String id, String displayName, Set<MetadataProperty> properties, Set<MetadataKey> childs, String partName) {
        this.id = id;
        this.displayName = displayName;
        this.childs = childs;
        this.properties = Collections.unmodifiableMap(properties.stream().collect(Collectors.toMap(Object::getClass, p -> p)));
        this.partName = partName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Set<MetadataKey> getChilds() {
        return Collections.unmodifiableSet(this.childs);
    }

    @Override
    public String getPartName() {
        return this.partName;
    }

    @Override
    public <T extends MetadataProperty> Optional<T> getMetadataProperty(Class<T> propertyType) {
        return Optional.ofNullable(this.properties.get(propertyType));
    }

    @Override
    public Set<MetadataProperty> getProperties() {
        return Collections.unmodifiableSet(new HashSet<MetadataProperty>(this.properties.values()));
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

