/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MuleException
extends Exception {
    private static final String MULE_VERBOSE_EXCEPTIONS = "mule.verbose.exceptions";
    public static final String INFO_LOCATION_KEY = "Element";
    public static final String INFO_SOURCE_XML_KEY = "Element XML";
    private static final long serialVersionUID = -4544199933449632546L;
    private static final Logger logger = LoggerFactory.getLogger(MuleException.class);
    private static final String EXCEPTION_MESSAGE_DELIMITER = MuleException.repeat('*', 80) + System.lineSeparator();
    private static final String EXCEPTION_MESSAGE_SECTION_DELIMITER = MuleException.repeat('-', 80) + System.lineSeparator();
    public static boolean verboseExceptions = false;
    private final Map<String, Object> info = new HashMap<String, Object>();
    private String message = null;
    private I18nMessage i18nMessage;

    public static void refreshVerboseExceptions() {
        String p = System.getProperty(MULE_VERBOSE_EXCEPTIONS);
        if (p != null) {
            verboseExceptions = Boolean.parseBoolean(p);
        }
    }

    public MuleException(I18nMessage message) {
        this(message, null);
    }

    public MuleException(I18nMessage message, Throwable cause) {
        super(null, ExceptionHelper.unwrap(cause), true, MuleException.isVerboseExceptions());
        this.setMessage(message);
    }

    public MuleException(Throwable cause) {
        this(cause != null ? I18nMessageFactory.createStaticMessage(cause.getMessage() + " (" + cause.getClass().getName() + ")") : null, cause);
    }

    private static String repeat(char c, int len) {
        String str = String.valueOf(c);
        if (str == null) {
            return null;
        }
        if (len <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            stringBuilder.append(str);
        }
        return stringBuilder.toString();
    }

    protected MuleException() {
        this((I18nMessage)null, (Throwable)null);
    }

    protected void setMessage(I18nMessage message) {
        this.message = message != null ? message.getMessage() : null;
        this.i18nMessage = message;
    }

    protected void setMessage(String message) {
        this.message = message;
        if (this.i18nMessage == null) {
            this.i18nMessage = I18nMessageFactory.createStaticMessage(message);
        }
    }

    public I18nMessage getI18nMessage() {
        return this.i18nMessage;
    }

    public int getMessageCode() {
        return this.i18nMessage == null ? 0 : this.i18nMessage.getCode();
    }

    public void addInfo(String name, Object info) {
        this.info.put(name, info);
    }

    protected void appendMessage(String s) {
        this.message = this.message + s;
    }

    protected void prependMessage(String s) {
        this.message = this.message + ". " + s;
    }

    @Override
    public final String getMessage() {
        return this.message;
    }

    public String getDetailedMessage() {
        if (MuleException.isVerboseExceptions()) {
            return this.getVerboseMessage();
        }
        return this.getSummaryMessage();
    }

    public String getVerboseMessage() {
        MuleException e = ExceptionHelper.getRootMuleException(this);
        if (!e.equals(this)) {
            return this.getMessage();
        }
        StringBuilder buf = new StringBuilder(1024);
        buf.append(System.lineSeparator()).append(EXCEPTION_MESSAGE_DELIMITER);
        buf.append("Message               : ").append(this.message).append(System.lineSeparator());
        Map<String, Object> info = ExceptionHelper.getExceptionInfo(this);
        for (Map.Entry<String, Object> entry : info.entrySet()) {
            String s = entry.getKey();
            int pad = 22 - s.length();
            buf.append(s);
            if (pad > 0) {
                buf.append(MuleException.repeat(' ', pad));
            }
            buf.append(": ");
            buf.append(entry.getValue() == null ? "null" : entry.getValue().toString().replaceAll(System.lineSeparator(), System.lineSeparator() + MuleException.repeat(' ', 24))).append(System.lineSeparator());
        }
        buf.append(EXCEPTION_MESSAGE_SECTION_DELIMITER);
        buf.append("Root Exception stack trace:").append(System.lineSeparator());
        Throwable root = ExceptionHelper.getRootException(this);
        StringWriter w = new StringWriter();
        PrintWriter p = new PrintWriter(w);
        root.printStackTrace(p);
        buf.append(w.toString()).append(System.lineSeparator());
        buf.append(EXCEPTION_MESSAGE_DELIMITER);
        return buf.toString();
    }

    public String getSummaryMessage() {
        MuleException e = ExceptionHelper.getRootMuleException(this);
        if (!e.equals(this)) {
            return this.getMessage();
        }
        StringBuilder buf = new StringBuilder(1024);
        buf.append(System.lineSeparator()).append(EXCEPTION_MESSAGE_DELIMITER);
        buf.append("Message               : ").append(this.message).append(System.lineSeparator());
        this.appendSummaryMessage(buf);
        buf.append(System.lineSeparator()).append("  (set debug level logging or '-Dmule.verbose.exceptions=true' for everything)").append(System.lineSeparator());
        buf.append(EXCEPTION_MESSAGE_DELIMITER);
        return buf.toString();
    }

    protected void appendSummaryMessage(StringBuilder builder) {
        Map<String, Object> exceptionInfo = ExceptionHelper.getExceptionInfo(this);
        builder.append("Element               : ").append(exceptionInfo.get(INFO_LOCATION_KEY)).append(System.lineSeparator());
        Object sourceXml = exceptionInfo.get(INFO_SOURCE_XML_KEY);
        if (sourceXml != null) {
            builder.append("Element XML           : ").append(sourceXml).append(System.lineSeparator());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MuleException)) {
            return false;
        }
        MuleException exception = (MuleException)o;
        if (this.i18nMessage != null ? !this.i18nMessage.equals(exception.i18nMessage) : exception.i18nMessage != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(exception.message) : exception.message != null);
    }

    public int hashCode() {
        int result = this.message != null ? this.message.hashCode() : 0;
        result = 29 * result + (this.i18nMessage != null ? this.i18nMessage.hashCode() : 0);
        return result;
    }

    public Map<String, Object> getInfo() {
        return this.info;
    }

    public static boolean isVerboseExceptions() {
        return verboseExceptions || logger.isDebugEnabled();
    }

    static {
        MuleException.refreshVerboseExceptions();
    }
}

