/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util;

import javax.xml.namespace.QName;
import org.mule.runtime.api.meta.AnnotatedObject;

public class ComponentLocationProvider {
    protected static final QName NAME_ANNOTATION_KEY = new QName("http://www.mulesoft.org/schema/mule/documentation", "name");

    public static String resolveProcessorRepresentation(String appId, String processorPath, Object element) {
        String docName;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(processorPath).append(" @ ").append(appId);
        String sourceFile = ComponentLocationProvider.getSourceFile((AnnotatedObject)element);
        if (sourceFile != null) {
            stringBuilder.append(":").append(sourceFile).append(":").append(ComponentLocationProvider.getSourceFileLine((AnnotatedObject)element));
        }
        if ((docName = ComponentLocationProvider.getDocName(element)) != null) {
            stringBuilder.append(" (").append(docName).append(")");
        }
        return stringBuilder.toString();
    }

    public static String getDocName(Object element) {
        if (element instanceof AnnotatedObject) {
            Object docName = ((AnnotatedObject)element).getAnnotation(NAME_ANNOTATION_KEY);
            return docName != null ? docName.toString() : null;
        }
        return null;
    }

    protected static String getSourceFile(AnnotatedObject element) {
        return element.getLocation() != null ? element.getLocation().getFileName().orElse("unknown") : "internal";
    }

    protected static Integer getSourceFileLine(AnnotatedObject element) {
        return element.getLocation() != null ? element.getLocation().getLineInFile().orElse(-1) : Integer.valueOf(-1);
    }
}

