/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata.descriptor;

import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;

public final class OutputMetadataDescriptor {
    private final TypeMetadataDescriptor content;
    private final TypeMetadataDescriptor attributes;

    private OutputMetadataDescriptor(TypeMetadataDescriptor content, TypeMetadataDescriptor attributes) {
        this.content = content;
        this.attributes = attributes;
    }

    public static OutputMetadataDescriptorBuilder builder() {
        return new OutputMetadataDescriptorBuilder();
    }

    public TypeMetadataDescriptor getPayloadMetadata() {
        return this.content;
    }

    public TypeMetadataDescriptor getAttributesMetadata() {
        return this.attributes;
    }

    public static class OutputMetadataDescriptorBuilder {
        private TypeMetadataDescriptor returnTypeResult;
        private TypeMetadataDescriptor attributes;

        private OutputMetadataDescriptorBuilder() {
        }

        public OutputMetadataDescriptorBuilder withReturnType(TypeMetadataDescriptor returnTypeResult) {
            this.returnTypeResult = returnTypeResult;
            return this;
        }

        public OutputMetadataDescriptorBuilder withAttributesType(TypeMetadataDescriptor attributesTypeResult) {
            this.attributes = attributesTypeResult;
            return this;
        }

        public OutputMetadataDescriptorBuilder withReturnType(MetadataType returnType) {
            this.returnTypeResult = TypeMetadataDescriptor.builder().withType(returnType).build();
            return this;
        }

        public OutputMetadataDescriptorBuilder withAttributesType(MetadataType attributesType) {
            this.attributes = TypeMetadataDescriptor.builder().withType(attributesType).build();
            return this;
        }

        public OutputMetadataDescriptor build() {
            if (this.returnTypeResult == null) {
                throw new IllegalArgumentException("Payload type parameter cannot be null for OutputMetadataDescriptor");
            }
            if (this.attributes == null) {
                throw new IllegalArgumentException("Attributes type parameter cannot be null for OutputMetadataDescriptor");
            }
            return new OutputMetadataDescriptor(this.returnTypeResult, this.attributes);
        }
    }
}

