/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.bulk;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.bulk.BulkItem;

public final class BulkOperationResult<T>
implements Serializable {
    private static final long serialVersionUID = 8039267004891928585L;
    private final Serializable id;
    private final boolean successful;
    private final List<BulkItem<T>> items;

    private BulkOperationResult(Serializable id, boolean successful, List<BulkItem<T>> items) {
        this.id = id;
        this.successful = successful;
        this.items = items;
    }

    public Serializable getId() {
        return this.id;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public List<BulkItem<T>> getItems() {
        return this.items;
    }

    public static <T> BulkOperationResultBuilder<T> builder() {
        return new BulkOperationResultBuilder();
    }

    public static class BulkOperationResultBuilder<T> {
        private Serializable id;
        private boolean successful = true;
        private List<BulkItem.BulkItemBuilder<T>> items = new ArrayList<BulkItem.BulkItemBuilder<T>>();

        private BulkOperationResultBuilder() {
        }

        public BulkOperationResultBuilder<T> setSuccessful(boolean successful) {
            this.successful = successful;
            return this;
        }

        public BulkOperationResultBuilder<T> setId(Serializable id) {
            this.id = id;
            return this;
        }

        public BulkOperationResultBuilder<T> addItem(BulkItem.BulkItemBuilder<T> recordResultBuilder) {
            this.items.add(recordResultBuilder);
            return this;
        }

        public BulkOperationResult<T> build() {
            if (this.items.isEmpty()) {
                throw new IllegalStateException("A BulkOperationResult must have at least one BulkItem. Please add a result an try again");
            }
            ArrayList<BulkItem<T>> items = new ArrayList<BulkItem<T>>(this.items.size());
            for (BulkItem.BulkItemBuilder<T> recordBuilder : this.items) {
                BulkItem<T> record = recordBuilder.build();
                items.add(record);
                if (record.isSuccessful()) continue;
                this.successful = false;
            }
            return new BulkOperationResult(this.id, this.successful, items);
        }
    }
}

