/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.app.declaration.fluent;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.app.declaration.ParameterValue;
import org.mule.runtime.api.app.declaration.ParameterValueVisitor;

public final class ParameterSimpleValue
implements ParameterValue {
    private static final Pattern CDATA = Pattern.compile("^<!\\[CDATA\\[(.+)\\]\\]>$", 40);
    private final String text;
    private final boolean isCData;

    private ParameterSimpleValue(String text, boolean asCData) {
        this.text = text;
        this.isCData = asCData;
    }

    public static ParameterValue of(String text) {
        return ParameterSimpleValue.isCData(text) ? ParameterSimpleValue.cdata(text) : ParameterSimpleValue.plain(text);
    }

    private static boolean isCData(String text) {
        return CDATA.matcher(text).matches();
    }

    public static ParameterValue plain(String text) {
        return new ParameterSimpleValue(text, false);
    }

    public static ParameterValue cdata(String text) {
        text = StringUtils.removeEnd((String)StringUtils.removeStart((String)text, (String)"<![CDATA["), (String)"]]>");
        return new ParameterSimpleValue(text, true);
    }

    public String getValue() {
        return this.text;
    }

    public boolean isCData() {
        return this.isCData;
    }

    @Override
    public void accept(ParameterValueVisitor valueVisitor) {
        valueVisitor.visitSimpleValue(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterSimpleValue that = (ParameterSimpleValue)o;
        return this.isCData ? that.isCData : !that.isCData && StringUtils.equals((CharSequence)this.text, (CharSequence)that.text);
    }

    public int hashCode() {
        return (this.isCData ? 31 : 0) + (this.text != null ? this.text.hashCode() : 0);
    }

    public String toString() {
        return this.text;
    }
}

