/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv2.v10.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.raml.implv2.v10.model.ParameterImpl;
import org.mule.raml.implv2.v10.model.RamlImpl10V2;
import org.mule.raml.interfaces.model.IMimeType;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.raml.v2.api.model.common.ValidationResult;
import org.raml.v2.api.model.v10.datamodel.ExampleSpec;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class MimeTypeImpl
implements IMimeType {
    private TypeDeclaration typeDeclaration;

    public MimeTypeImpl(TypeDeclaration typeDeclaration) {
        this.typeDeclaration = typeDeclaration;
    }

    public String getType() {
        return this.typeDeclaration.name();
    }

    public String getExample() {
        ExampleSpec example = this.typeDeclaration.example();
        if (example != null && example.value() != null) {
            return example.value();
        }
        List examples = this.typeDeclaration.examples();
        if (examples != null && !examples.isEmpty() && ((ExampleSpec)examples.get(0)).value() != null) {
            return ((ExampleSpec)examples.get(0)).value();
        }
        return null;
    }

    public String getSchema() {
        return RamlImpl10V2.getTypeAsString(this.typeDeclaration);
    }

    public Map<String, List<IParameter>> getFormParameters() {
        LinkedHashMap<String, List<IParameter>> result = new LinkedHashMap<String, List<IParameter>>();
        if (this.typeDeclaration instanceof ObjectTypeDeclaration) {
            List parameters = ((ObjectTypeDeclaration)this.typeDeclaration).properties();
            for (TypeDeclaration parameter : parameters) {
                ArrayList<ParameterImpl> list = new ArrayList<ParameterImpl>();
                list.add(new ParameterImpl(parameter));
                result.put(parameter.name(), list);
            }
        }
        return result;
    }

    public List<ValidationResult> validate(String payload) {
        return this.typeDeclaration.validate(payload);
    }

    public Object getCompiledSchema() {
        throw new UnsupportedOperationException();
    }

    public Object getInstance() {
        throw new UnsupportedOperationException();
    }
}

