/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv2.v08.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.raml.implv2.v08.model.MimeTypeImpl;
import org.mule.raml.implv2.v08.model.ParameterImpl;
import org.mule.raml.implv2.v08.model.ResourceImpl;
import org.mule.raml.implv2.v08.model.ResponseImpl;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IActionType;
import org.mule.raml.interfaces.model.IMimeType;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.IResponse;
import org.mule.raml.interfaces.model.ISecurityReference;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.raml.v2.api.model.v08.bodies.BodyLike;
import org.raml.v2.api.model.v08.bodies.Response;
import org.raml.v2.api.model.v08.methods.Method;
import org.raml.v2.api.model.v08.parameters.Parameter;

public class ActionImpl
implements IAction {
    private Method method;

    public ActionImpl(Method method) {
        this.method = method;
    }

    public IActionType getType() {
        return IActionType.valueOf((String)this.method.method().toUpperCase());
    }

    public boolean hasBody() {
        return !this.method.body().isEmpty();
    }

    public Map<String, IResponse> getResponses() {
        LinkedHashMap<String, IResponse> result = new LinkedHashMap<String, IResponse>();
        for (Response response : this.method.responses()) {
            result.put(response.code().value(), new ResponseImpl(response));
        }
        return result;
    }

    public Map<String, IMimeType> getBody() {
        LinkedHashMap<String, IMimeType> result = new LinkedHashMap<String, IMimeType>();
        for (BodyLike bodyLike : this.method.body()) {
            result.put(bodyLike.name(), new MimeTypeImpl(bodyLike));
        }
        return result;
    }

    public IResource getResource() {
        return new ResourceImpl(this.method.resource());
    }

    public Map<String, List<IParameter>> getBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public Map<String, IParameter> getQueryParameters() {
        HashMap<String, IParameter> result = new HashMap<String, IParameter>();
        for (Parameter parameter : this.method.queryParameters()) {
            result.put(parameter.name(), new ParameterImpl(parameter));
        }
        return result;
    }

    public Map<String, IParameter> getHeaders() {
        HashMap<String, IParameter> result = new HashMap<String, IParameter>();
        for (Parameter parameter : this.method.headers()) {
            result.put(parameter.name(), new ParameterImpl(parameter));
        }
        return result;
    }

    public List<ISecurityReference> getSecuredBy() {
        throw new UnsupportedOperationException();
    }

    public List<String> getIs() {
        throw new UnsupportedOperationException();
    }

    public void cleanBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public void setHeaders(Map<String, IParameter> headers) {
        throw new UnsupportedOperationException();
    }

    public void setQueryParameters(Map<String, IParameter> queryParameters) {
        throw new UnsupportedOperationException();
    }

    public void setBody(Map<String, IMimeType> body) {
        throw new UnsupportedOperationException();
    }

    public void addResponse(String key, IResponse response) {
        throw new UnsupportedOperationException();
    }

    public void addSecurityReference(String securityReferenceName) {
        throw new UnsupportedOperationException();
    }

    public void addIs(String is) {
        throw new UnsupportedOperationException();
    }
}

