/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal.util;

import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;

public class VersionChecker {
    public static boolean areCompatibleVersions(String version1, String version2) {
        return VersionChecker.getSemver(version1).getMajor().equals(VersionChecker.getSemver(version2).getMajor());
    }

    public static String getHighestVersion(String version1, String version2) {
        Semver semver1 = new Semver(version1, Semver.SemverType.LOOSE);
        Semver semver2 = new Semver(version2, Semver.SemverType.LOOSE);
        return semver1.isGreaterThan(semver2) ? semver1.getOriginalValue() : semver2.getOriginalValue();
    }

    public static boolean isHighestVersion(String version1, String version2) {
        Semver semver1 = new Semver(version1, Semver.SemverType.LOOSE);
        Semver semver2 = new Semver(version2, Semver.SemverType.LOOSE);
        return semver1.isGreaterThan(semver2);
    }

    private static Semver getSemver(String version) {
        try {
            return new Semver(version, Semver.SemverType.LOOSE);
        }
        catch (SemverException e) {
            throw new IllegalArgumentException(String.format("Unable to parse version %s, version is not following semantic versioning", version), e);
        }
    }
}

