/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.api.model;

import java.util.Objects;

public class RepositoryPolicy {
    public static final String UPDATE_POLICY_NEVER = "never";
    public static final String UPDATE_POLICY_ALWAYS = "always";
    public static final String UPDATE_POLICY_DAILY = "daily";
    public static final String UPDATE_POLICY_INTERVAL = "interval";
    public static final String CHECKSUM_POLICY_FAIL = "fail";
    public static final String CHECKSUM_POLICY_WARN = "warn";
    public static final String CHECKSUM_POLICY_IGNORE = "ignore";
    private final boolean enabled;
    private final String updatePolicy;
    private final String checksumPolicy;

    private RepositoryPolicy(boolean enabled, String updatePolicy, String checksumPolicy) {
        Objects.requireNonNull(updatePolicy, "updatePolicy cannot be null");
        Objects.requireNonNull(checksumPolicy, "checksumPolicy cannot be null");
        this.enabled = enabled;
        this.updatePolicy = updatePolicy;
        this.checksumPolicy = checksumPolicy;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("enabled=").append(this.isEnabled());
        buffer.append(", checksums=").append(this.getChecksumPolicy());
        buffer.append(", updates=").append(this.getUpdatePolicy());
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass().equals(obj.getClass())) {
            RepositoryPolicy that = (RepositoryPolicy)obj;
            return this.enabled == that.enabled && this.updatePolicy.equals(that.updatePolicy) && this.checksumPolicy.equals(that.checksumPolicy);
        }
        return false;
    }

    public int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + this.updatePolicy.hashCode();
        result = 31 * result + this.checksumPolicy.hashCode();
        return result;
    }

    public static RepositoryPolicyBuilder newRepositoryPolicyBuilder() {
        return new RepositoryPolicyBuilder();
    }

    public static class RepositoryPolicyBuilder {
        private boolean enabled = true;
        private String updatePolicy = "daily";
        private String checksumPolicy = "warn";

        public RepositoryPolicyBuilder enabled(boolean enabled) {
            Objects.requireNonNull(Boolean.valueOf(enabled), "enabled cannot be null");
            this.enabled = enabled;
            return this;
        }

        public RepositoryPolicyBuilder updatePolicy(String updatePolicy) {
            Objects.requireNonNull(updatePolicy, "updatePolicy cannot be null");
            this.updatePolicy = updatePolicy;
            return this;
        }

        public RepositoryPolicyBuilder checksumPolicy(String checksumPolicy) {
            Objects.requireNonNull(checksumPolicy, "checksumPolicy cannot be null");
            this.checksumPolicy = checksumPolicy;
            return this;
        }

        public RepositoryPolicy build() {
            return new RepositoryPolicy(this.enabled, this.updatePolicy, this.checksumPolicy);
        }
    }
}

