/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.api.model;

import java.util.Objects;
import org.mule.maven.client.api.model.ImmutableAuthentication;

public interface Authentication {
    public String getPassword();

    public String getUsername();

    public static AuthenticationBuilder newAuthenticationBuilder() {
        return new AuthenticationBuilder();
    }

    public static class AuthenticationBuilder {
        private String password;
        private String username;

        public AuthenticationBuilder password(String password) {
            Objects.requireNonNull(password, "password cannot be null");
            this.password = password;
            return this;
        }

        public AuthenticationBuilder username(String username) {
            Objects.requireNonNull(username, "username cannot be null");
            this.username = username;
            return this;
        }

        public Authentication build() {
            return new ImmutableAuthentication(this.username, this.password);
        }
    }
}

