/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.security.microsoft.microsoftonline.crm;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jetbrains.annotations.NotNull;
import org.mule.modules.security.microsoft.MicrosoftAuthenticationException;
import org.mule.modules.security.microsoft.utils.UriUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class CrmOnlineAuthenticationPolicy {
    private String appliesTo;
    private URI issuerUri;
    private String microsoftOnlineIdentifier;
    private XPath xpath = XPathFactory.newInstance().newXPath();
    private String acsIdentifier;
    private String acsIssuer;
    private String crmIdentifier;
    private String liveIdPolicy;

    public CrmOnlineAuthenticationPolicy(String organizationWsdlUrl) throws ParserConfigurationException, SAXException, IOException, URISyntaxException, XPathExpressionException, MicrosoftAuthenticationException {
        this.initialize(organizationWsdlUrl);
    }

    public CrmOnlineAuthenticationPolicy(String appliesTo, URI issuerUri) {
        this.setAppliesTo(appliesTo);
        this.setIssuerUri(issuerUri);
    }

    private void initialize(@NotNull String organizationWsdlUrl) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException, URISyntaxException, MicrosoftAuthenticationException {
        Document wsdlDocument = this.downloadWsdlIntoDocument(organizationWsdlUrl);
        Node onlineFederationAuhtPolicyNode = this.getOnlineFederationAuthPolicyNode(wsdlDocument);
        if (onlineFederationAuhtPolicyNode == null) {
            throw new MicrosoftAuthenticationException("WSDL Exception: 'OnlineFederation' AuthenticationPolicy not present in the WSDL: " + organizationWsdlUrl);
        }
        this.appliesTo = this.readStringValue(onlineFederationAuhtPolicyNode, "SecureTokenService/OrgTrust/AppliesTo");
        if (Strings.isNullOrEmpty((String)this.appliesTo)) {
            throw new MicrosoftAuthenticationException("WSDL Exception: Unable to read the 'OrgTrust/AppliesTo' from the WSDL in this location: " + organizationWsdlUrl);
        }
        this.microsoftOnlineIdentifier = this.readStringValue(onlineFederationAuhtPolicyNode, "SecureTokenService/OrgTrust/Identifier");
        this.setAcsIdentifier(this.readStringValue(onlineFederationAuhtPolicyNode, "SecureTokenService/Identifier"));
        this.liveIdPolicy = this.readStringValue(onlineFederationAuhtPolicyNode, "SecureTokenService/OrgTrust/LivePolicy");
        String liveEndpoint = this.readStringValue(onlineFederationAuhtPolicyNode, "SecureTokenService/OrgTrust/LiveEndpoint");
        if (Strings.isNullOrEmpty((String)liveEndpoint)) {
            // empty if block
        }
        this.issuerUri = new URI(liveEndpoint);
        Node metadataReferenceNode = (Node)this.xpath.compile("//*[local-name()='MetadataReference']").evaluate(wsdlDocument, XPathConstants.NODE);
        if (metadataReferenceNode != null) {
            String metadataReferenceUrl = this.readStringValue(metadataReferenceNode, "Address");
            String metadataBaseUrl = UriUtils.getRootUri(metadataReferenceUrl);
            this.setAcsIssuer(metadataBaseUrl + "/v2/wstrust/13/issuedtoken-asymmetric");
        }
        this.setCrmIdentifier(UriUtils.getRootUri(organizationWsdlUrl) + "/");
    }

    private Node getOnlineFederationAuthPolicyNode(Document wsdlDocument) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        NodeList authPolicies = (NodeList)this.xpath.compile("//*[local-name()='AuthenticationPolicy']").evaluate(wsdlDocument, XPathConstants.NODESET);
        Node onlineFederationAuhtPolicyNode = null;
        for (int i = 0; i < authPolicies.getLength(); ++i) {
            Node authPolicy = authPolicies.item(i);
            String authenticationPolicyType = this.xpath.compile("Authentication").evaluate(authPolicy);
            if (!"OnlineFederation".equalsIgnoreCase(authenticationPolicyType)) continue;
            onlineFederationAuhtPolicyNode = authPolicy;
            break;
        }
        return onlineFederationAuhtPolicyNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document downloadWsdlIntoDocument(String flatWsdlUrl) throws IOException, ParserConfigurationException, SAXException {
        URL url = new URL(flatWsdlUrl);
        try (InputStream ins = null;){
            Document xmlDocument;
            ins = url.openConnection().getInputStream();
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document document = xmlDocument = builder.parse(ins);
            return document;
        }
    }

    private String readStringValue(Node onlineFederationAuhtPolicyNode, String xpathQueryExpression) throws XPathExpressionException {
        return this.xpath.compile(xpathQueryExpression).evaluate(onlineFederationAuhtPolicyNode);
    }

    public final String getAppliesTo() {
        return this.appliesTo;
    }

    private void setAppliesTo(String value) {
        this.appliesTo = value;
    }

    public final URI getIssuerUri() {
        return this.issuerUri;
    }

    private void setIssuerUri(URI value) {
        this.issuerUri = value;
    }

    public String getMicrosoftOnlineIdentifier() {
        return this.microsoftOnlineIdentifier;
    }

    public void setMicrosoftOnlineIdentifier(String identifier) {
        this.microsoftOnlineIdentifier = identifier;
    }

    public String getAcsIdentifier() {
        return this.acsIdentifier;
    }

    public void setAcsIdentifier(String acsIdentifier) {
        this.acsIdentifier = acsIdentifier;
    }

    public String getAcsIssuer() {
        return this.acsIssuer;
    }

    public void setAcsIssuer(String acsIssuer) {
        this.acsIssuer = acsIssuer;
    }

    public String getCrmIdentifier() {
        return this.crmIdentifier;
    }

    public void setCrmIdentifier(String crmIdentifier) {
        this.crmIdentifier = crmIdentifier;
    }

    public String getLiveIdPolicy() {
        return this.liveIdPolicy;
    }

    public void setLiveIdPolicy(String liveIdPolicy) {
        this.liveIdPolicy = liveIdPolicy;
    }
}

