/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.security.microsoft.microsoftonline;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.mule.modules.security.microsoft.InvalidCredentialsException;
import org.mule.modules.security.microsoft.MicrosoftAuthenticationBase;
import org.mule.modules.security.microsoft.MicrosoftAuthenticationException;
import org.mule.modules.security.microsoft.adfs.AdfsAuthentication;
import org.mule.modules.security.microsoft.microsoftonline.RealmInfo;
import org.mule.modules.security.microsoft.microsoftonline.crm.CrmOnlineAuthenticationPolicy;
import org.mule.modules.security.microsoft.utils.SamlTokenUtils;

public final class MicrosoftOnlineAuthentication
extends MicrosoftAuthenticationBase {
    private static final Log log = LogFactory.getLog(MicrosoftOnlineAuthentication.class);
    private static final String MICROSOFTONLINE_USERREALM_URL = "https://login.microsoftonline.com/GetUserRealm.srf";
    private static final String MICROSOFTONLINE_STS_URL = "https://login.microsoftonline.com/extSTS.srf";
    private static final String MICROSOFTONLINE_REALM = "urn:federation:MicrosoftOnline";

    public MicrosoftOnlineAuthentication() throws MicrosoftAuthenticationException {
        this(false);
    }

    public MicrosoftOnlineAuthentication(boolean disableSslCheck) throws MicrosoftAuthenticationException {
        this(MicrosoftOnlineAuthentication.createHttpClient(disableSslCheck));
    }

    public MicrosoftOnlineAuthentication(CloseableHttpClient httpClient) {
        super(httpClient);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RealmInfo getUserRealmInfo(CloseableHttpClient httpClient, String username) throws MicrosoftAuthenticationException {
        HttpPost post = new HttpPost(MICROSOFTONLINE_USERREALM_URL);
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("login", username));
        parameters.add(new BasicNameValuePair("xml", "1"));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parameters, Charset.forName("UTF-8"));
        post.setEntity((HttpEntity)entity);
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RealmInfo.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            RealmInfo realmInfo = (RealmInfo)jaxbUnmarshaller.unmarshal(response.getEntity().getContent());
            return realmInfo;
        }
        catch (JAXBException e) {
            throw MicrosoftAuthenticationException.onlineRealmInfoParsingError(e);
        }
        catch (IOException e) {
            throw MicrosoftAuthenticationException.onlineRealmInfoRequestError(e);
        }
    }

    public String getSecurityTokenForSharepointOnline(String username, String password, URL sharepointSiteUrl, int authenticationRetries) throws MicrosoftAuthenticationException {
        return this.getSecurityTokenForSharepointOnline(username, password, sharepointSiteUrl, "{http://schemas.microsoft.com/ws/2008/06/identity/securitytokenservice}UserNameWSTrustBinding_IWSTrust13Async", authenticationRetries);
    }

    public String getSecurityTokenForSharepointOnline(String username, String password, URL sharepointSiteUrl, String adfsUsernamePortName, int authenticationRetries) throws MicrosoftAuthenticationException {
        RealmInfo realmInfo = this.getUserRealmInfo(this.getHttpClient(), username);
        String baseSite = sharepointSiteUrl.toString().substring(0, sharepointSiteUrl.toString().length() - sharepointSiteUrl.getPath().length());
        for (int i = 1; i <= authenticationRetries; ++i) {
            try {
                if ("Managed".equalsIgnoreCase(realmInfo.getNamespaceType())) {
                    return this.getTokenFromMicrosoftOnline(username, password, MICROSOFTONLINE_STS_URL, baseSite);
                }
                if ("Federated".equalsIgnoreCase(realmInfo.getNamespaceType())) {
                    AdfsAuthentication adfsAuthentication = new AdfsAuthentication(this.getHttpClient());
                    String adfsSecurityTokenResponse = adfsAuthentication.getTokenFromAdfs(username, password, MICROSOFTONLINE_REALM, realmInfo.getMetadataUrl(), adfsUsernamePortName);
                    String adfsTokenForMicrosoftOnline = SamlTokenUtils.getRequestedSecurityTokenFromSecurityTokenResponse(adfsSecurityTokenResponse);
                    return this.getTokenFromMicrosoftOnline(adfsTokenForMicrosoftOnline, MICROSOFTONLINE_STS_URL, baseSite);
                }
                throw InvalidCredentialsException.onlineUnknownRealm();
            }
            catch (Exception e) {
                log.info((Object)"Error trying to authenticate for SharePoint Online.", (Throwable)e);
                if (i >= authenticationRetries) {
                    if (e instanceof MicrosoftAuthenticationException) {
                        throw e;
                    }
                    throw MicrosoftAuthenticationException.genericRequestSecurityTokenError("SharePoint", e);
                }
                log.info((Object)("Retries left: " + (authenticationRetries - i)));
                continue;
            }
        }
        throw MicrosoftAuthenticationException.genericRequestSecurityTokenError("SharePoint");
    }

    public String getSecurityTokenForCrmOnline(String username, String password, URL organizationServiceUrl, int authenticationRetries) throws MicrosoftAuthenticationException {
        return this.getSecurityTokenForCrmOnline(username, password, organizationServiceUrl, "{http://schemas.microsoft.com/ws/2008/06/identity/securitytokenservice}UserNameWSTrustBinding_IWSTrust13Async", authenticationRetries);
    }

    public String getSecurityTokenForCrmOnline(String username, String password, URL organizationServiceUrl, String adfsUsernamePortName, int authenticationRetries) throws MicrosoftAuthenticationException {
        CrmOnlineAuthenticationPolicy crmAuthenticationPolicy;
        String organizationWsdlUrl = organizationServiceUrl + "?WSDL=wsdl0";
        try {
            crmAuthenticationPolicy = new CrmOnlineAuthenticationPolicy(organizationWsdlUrl);
        }
        catch (Exception e) {
            throw new MicrosoftAuthenticationException("[CRM] Error trying to read the CRM authentication policy from '" + organizationWsdlUrl + "'", e);
        }
        RealmInfo realmInfo = this.getUserRealmInfo(this.getHttpClient(), username);
        for (int i = 1; i <= authenticationRetries; ++i) {
            try {
                if ("Managed".equalsIgnoreCase(realmInfo.getNamespaceType())) {
                    return this.getTokenFromMicrosoftOnline(username, password, crmAuthenticationPolicy.getIssuerUri().toString(), crmAuthenticationPolicy.getAppliesTo());
                }
                if ("Federated".equalsIgnoreCase(realmInfo.getNamespaceType())) {
                    AdfsAuthentication adfsAuthentication = new AdfsAuthentication(this.getHttpClient());
                    String adfsTokenForMicrosoftOnline = adfsAuthentication.getTokenFromAdfs(username, password, crmAuthenticationPolicy.getMicrosoftOnlineIdentifier(), realmInfo.getMetadataUrl(), adfsUsernamePortName);
                    return null;
                }
                throw InvalidCredentialsException.onlineUnknownRealm();
            }
            catch (Exception e) {
                log.info((Object)"Error trying to authenticate for CRM Online.", (Throwable)e);
                if (i >= authenticationRetries) {
                    if (e instanceof MicrosoftAuthenticationException) {
                        throw e;
                    }
                    throw MicrosoftAuthenticationException.genericRequestSecurityTokenError("CRM", e);
                }
                log.info((Object)("Retries left: " + (authenticationRetries - i)));
                continue;
            }
        }
        throw MicrosoftAuthenticationException.genericRequestSecurityTokenError("CRM");
    }

    public String getTokenFromMicrosoftOnline(String username, String password, String issuerUrl, String appliesTo) throws MicrosoftAuthenticationException {
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        Calendar calendar = Calendar.getInstance(gmt);
        Calendar calendarFiveMinute = (Calendar)calendar.clone();
        calendarFiveMinute.add(12, 5);
        Date nowDate = calendar.getTime();
        Date fiveMinuteFromNow = calendarFiveMinute.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        formatter.setTimeZone(gmt);
        String soapMessageTemplate = this.loadSoapMessage("MicrosoftOnlineUsernamePassword.xml");
        String messageId = UUID.randomUUID().toString();
        String toId = UUID.randomUUID().toString();
        String timestampId = UUID.randomUUID().toString();
        String created = formatter.format(nowDate);
        String expires = formatter.format(fiveMinuteFromNow);
        String usernameTokenId = UUID.randomUUID().toString();
        String body = String.format(soapMessageTemplate, messageId, toId, issuerUrl, timestampId, created, expires, usernameTokenId, username, password, appliesTo);
        return MicrosoftOnlineAuthentication.getSecurityTokenRequestResponseFromSts("MicrosoftOnline", this.getHttpClient(), issuerUrl, body);
    }

    private String getTokenFromMicrosoftOnline(String issuedToken, String issuerUrl, String appliesTo) throws MicrosoftAuthenticationException {
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        Calendar calendar = Calendar.getInstance(gmt);
        Calendar calendarFiveMinute = (Calendar)calendar.clone();
        calendarFiveMinute.add(12, 5);
        Date nowDate = calendar.getTime();
        Date fiveMinuteFromNow = calendarFiveMinute.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        formatter.setTimeZone(gmt);
        String soapMessageTemplate = this.loadSoapMessage("MicrosoftOnlineIssuedToken.xml");
        String messageId = UUID.randomUUID().toString();
        String timestampId = UUID.randomUUID().toString();
        String created = formatter.format(nowDate);
        String expires = formatter.format(fiveMinuteFromNow);
        String body = String.format(soapMessageTemplate, messageId, issuerUrl, timestampId, created, expires, issuedToken, appliesTo);
        return MicrosoftOnlineAuthentication.getSecurityTokenRequestResponseFromSts("MicrosoftOnline", this.getHttpClient(), issuerUrl, body);
    }
}

