/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.internal.util;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Result;
import net.sf.saxon.lib.StandardOutputResolver;
import net.sf.saxon.trans.XPathException;

public class FileSchemeCorrectionOutputUriResolver
extends StandardOutputResolver {
    private static final String PATH_URI_SCHEME = "file:";

    public Result resolve(String href, String base) throws XPathException {
        if (base == null && !this.hasUriScheme(href)) {
            href = PATH_URI_SCHEME.concat(href);
        }
        return super.resolve(href, base);
    }

    protected boolean hasUriScheme(String href) {
        try {
            URI parsedUri = new URI(href);
            return parsedUri.getScheme() != null;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

