/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.internal.operation;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PoolUtils;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.mule.module.xml.api.EntityExpansion;
import org.mule.module.xml.internal.error.TransformationException;
import org.mule.module.xml.internal.util.LocalEntityResolver;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.xml.sax.EntityResolver;

public abstract class PooledTransformerOperation<K, T>
implements Initialisable,
Startable,
Stoppable {
    private static final int MIN_IDLE_POOL_COUNT = 1;
    private static final int MAX_IDLE_POOL_COUNT = 32;
    protected DocumentBuilderFactory documentBuilderFactory;
    protected EntityResolver entityResolver = new LocalEntityResolver();
    private LoadingCache<K, GenericObjectPool<T>> transformerPools;
    @Parameter
    @ConfigOverride
    @Placement(tab="Security")
    @Summary(value="Set to NEVER to prevent XXE and DoS attacks")
    protected EntityExpansion expandEntities = EntityExpansion.NEVER;

    public final void initialise() throws InitialisationException {
        try {
            this.documentBuilderFactory = XMLSecureFactories.createWithConfig((Boolean)this.expandEntities.isAcceptExternalEntities(), (Boolean)this.expandEntities.isExpandInternalEntities()).getDocumentBuilderFactory();
            this.documentBuilderFactory.setNamespaceAware(true);
            this.doInitialise();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void doInitialise() throws InitialisationException {
    }

    public final void start() throws MuleException {
        this.transformerPools = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(notification -> ((GenericObjectPool)notification.getValue()).close()).build(new CacheLoader<K, GenericObjectPool<T>>(){

            public GenericObjectPool<T> load(K key) throws Exception {
                return PooledTransformerOperation.this.createPool(PooledTransformerOperation.this.createPooledObjectFactory(key));
            }
        });
    }

    public final void stop() throws MuleException {
        this.transformerPools.invalidateAll();
    }

    protected abstract BasePooledObjectFactory<T> createPooledObjectFactory(K var1);

    protected <V> V withTransformer(K key, CheckedFunction<T, V> func) {
        GenericObjectPool pool = (GenericObjectPool)this.transformerPools.getUnchecked(key);
        Object transformer = null;
        try {
            transformer = pool.borrowObject();
            Object object = func.apply(transformer);
            return (V)object;
        }
        catch (Exception e) {
            Optional cause = ExceptionUtils.extractOfType((Throwable)e, ModuleException.class);
            if (cause.isPresent()) {
                throw (ModuleException)cause.get();
            }
            throw new TransformationException(e.getMessage(), e);
        }
        finally {
            if (transformer != null) {
                pool.returnObject(transformer);
            }
        }
    }

    private <T> GenericObjectPool<T> createPool(BasePooledObjectFactory<T> factory) {
        return new GenericObjectPool(PoolUtils.synchronizedPooledFactory(factory), this.defaultPoolConfig());
    }

    private GenericObjectPoolConfig defaultPoolConfig() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMinIdle(1);
        config.setMaxIdle(32);
        config.setMaxTotal(32);
        config.setBlockWhenExhausted(true);
        config.setTimeBetweenEvictionRunsMillis(TimeUnit.MINUTES.toMillis(5L));
        config.setTestOnBorrow(false);
        config.setTestOnReturn(this.testOnReturn());
        config.setTestWhileIdle(false);
        config.setTestOnCreate(false);
        config.setJmxEnabled(false);
        return config;
    }

    protected boolean testOnReturn() {
        return false;
    }
}

