/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.internal.operation;

import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Controller;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.mule.module.xml.internal.XmlModule;
import org.mule.module.xml.internal.error.NullContextPropertyException;
import org.mule.module.xml.internal.error.StandardXmlErrorTypeProvider;
import org.mule.module.xml.internal.error.TransformationException;
import org.mule.module.xml.internal.error.TransformerErrorListener;
import org.mule.module.xml.internal.operation.PooledTransformerOperation;
import org.mule.module.xml.internal.util.XMLUtils;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.w3c.dom.Node;

public class XsltOperation
extends PooledTransformerOperation<String, XsltTransformer> {
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    @MediaType(value="*/*", strict=false)
    @Throws(value={StandardXmlErrorTypeProvider.class})
    public String xsltTransform(@Content(primary=true) InputStream content, @Text String xslt, @Optional @Content @NullSafe Map<String, Object> contextProperties, @DefaultEncoding String outputEncoding, @Config XmlModule config) {
        Node node = XMLUtils.toDOMNode(content, this.documentBuilderFactory, this.entityResolver);
        TransformerErrorListener errorListener = new TransformerErrorListener();
        return (String)this.withTransformer(xslt, transformer -> {
            this.bindParameters((XsltTransformer)transformer, contextProperties);
            transformer.setErrorListener((ErrorListener)errorListener);
            StringWriter writer = new StringWriter();
            Serializer out = (Serializer)transformer.getDestination();
            out.setOutputWriter((Writer)writer);
            out.setOutputProperty(Serializer.Property.ENCODING, outputEncoding);
            transformer.setSource((Source)new DOMSource(node));
            transformer.transform();
            if (errorListener.getException().isPresent()) {
                throw errorListener.getException().get();
            }
            return writer.toString();
        });
    }

    private void bindParameters(XsltTransformer transformer, Map<String, Object> contextProperties) {
        contextProperties.forEach((key, value) -> {
            XdmAtomicValue xdmValue;
            if (value == null) {
                throw new NullContextPropertyException(String.format("Context property '%s' resolved to a null value. Null values are not allowed here", key));
            }
            if (value instanceof String) {
                xdmValue = new XdmAtomicValue((String)value);
            } else if (value instanceof InputStream) {
                xdmValue = new XdmAtomicValue(IOUtils.toString((InputStream)((InputStream)value)));
            } else if (value instanceof Integer) {
                xdmValue = new XdmAtomicValue(((Long)value).longValue());
            } else if (value instanceof Boolean) {
                xdmValue = new XdmAtomicValue(((Boolean)value).booleanValue());
            } else if (value instanceof Long) {
                xdmValue = new XdmAtomicValue(((Long)value).longValue());
            } else if (value instanceof Double) {
                xdmValue = new XdmAtomicValue(((Double)value).doubleValue());
            } else if (value instanceof Short) {
                xdmValue = new XdmAtomicValue(((Short)value).shortValue());
            } else if (value instanceof Byte) {
                xdmValue = new XdmAtomicValue(((Byte)value).byteValue());
            } else if (value instanceof Float) {
                xdmValue = new XdmAtomicValue(((Float)value).floatValue());
            } else {
                throw new TransformationException(String.format("Cannot bind value for key '%s' because type '%s' is not supported", key, value.getClass().getName()));
            }
            transformer.setParameter(new QName(key), (XdmValue)xdmValue);
        });
    }

    @Override
    protected BasePooledObjectFactory createPooledObjectFactory(final String xslt) {
        return new BasePooledObjectFactory<XsltTransformer>(){

            public XsltTransformer create() throws Exception {
                Processor proc = new Processor(false);
                XsltCompiler comp = proc.newXsltCompiler();
                XsltExecutable exp = comp.compile((Source)new StreamSource(new StringReader(xslt)));
                Serializer out = proc.newSerializer();
                XsltTransformer trans = exp.load();
                trans.setDestination((Destination)out);
                return trans;
            }

            public PooledObject<XsltTransformer> wrap(XsltTransformer transformer) {
                return new DefaultPooledObject((Object)transformer);
            }

            public void passivateObject(PooledObject<XsltTransformer> p) throws Exception {
                XsltTransformer transformer = (XsltTransformer)p.getObject();
                transformer.clearParameters();
                transformer.setSource(null);
                Controller controller = transformer.getUnderlyingController();
                if (controller != null) {
                    controller.reset();
                }
                ((Serializer)transformer.getDestination()).setOutputWriter(null);
            }
        };
    }
}

