/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import com.google.common.net.InetAddresses;
import org.mule.extension.validation.api.ValidationErrorType;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;
import org.mule.runtime.api.i18n.I18nMessage;

public class IpValidator
extends AbstractValidator {
    private final String ip;

    public IpValidator(String ip, ValidationContext validationContext) {
        super(validationContext);
        this.ip = ip;
    }

    @Override
    public ValidationResult validate() {
        return InetAddresses.isInetAddress((String)this.ip) ? ImmutableValidationResult.ok() : this.fail();
    }

    @Override
    protected ValidationErrorType getErrorType() {
        return ValidationErrorType.INVALID_IP;
    }

    @Override
    protected I18nMessage getDefaultErrorMessage() {
        return this.getMessages().invalidIp(this.ip);
    }
}

