/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mule.tracing.module.internal;

import org.mule.extension.mule.tracing.module.internal.AbstractLifecycleDelegate;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.api.runtime.privileged.EventedExecutionContext;

public class MDCInjectorComponentExecutorDecorator
extends AbstractLifecycleDelegate<CompletableComponentExecutor<ComponentModel>>
implements CompletableComponentExecutor<ComponentModel> {
    private static final String SET_LOGGING_VARIABLE_NAME = "setLoggingVariable";
    private static final String REMOVE_LOGGING_VARIABLE_NAME = "removeLoggingVariable";
    private static final String CLEAR_LOGGING_VARIABLES_NAME = "clearLoggingVariables";
    private static final String VARIABLE_NAME_PARAMETER_NAME = "variableName";
    private static final String VALUE_PARAMETER_NAME = "value";
    private final String operationName;

    MDCInjectorComponentExecutorDecorator(CompletableComponentExecutor<ComponentModel> delegate, String operationName) {
        super(delegate);
        this.operationName = operationName;
    }

    public void execute(ExecutionContext<ComponentModel> executionContext, CompletableComponentExecutor.ExecutorCallback executorCallback) {
        if (executionContext instanceof EventedExecutionContext) {
            CoreEvent originalEvent = ((EventedExecutionContext)executionContext).getEvent();
            CoreEvent newEvent = this.executeOperation(originalEvent, executionContext);
            ((EventedExecutionContext)executionContext).changeEvent(newEvent);
        }
        ((CompletableComponentExecutor)this.getDelegate()).execute(executionContext, executorCallback);
    }

    private CoreEvent executeOperation(CoreEvent originalEvent, ExecutionContext<ComponentModel> executionContext) {
        if (this.operationName.contentEquals(SET_LOGGING_VARIABLE_NAME)) {
            String variableName = (String)executionContext.getParameter(VARIABLE_NAME_PARAMETER_NAME);
            String value = (String)executionContext.getParameter(VALUE_PARAMETER_NAME);
            return this.setLoggingVariable(originalEvent, variableName, value);
        }
        if (this.operationName.contentEquals(REMOVE_LOGGING_VARIABLE_NAME)) {
            String variableName = (String)executionContext.getParameter(VARIABLE_NAME_PARAMETER_NAME);
            return this.removeLoggingVariable(originalEvent, variableName);
        }
        if (this.operationName.contentEquals(CLEAR_LOGGING_VARIABLES_NAME)) {
            return this.clearLoggingVariables(originalEvent);
        }
        throw new UnsupportedOperationException("Operation not found: " + this.operationName);
    }

    private CoreEvent clearLoggingVariables(CoreEvent originalEvent) {
        return PrivilegedEvent.builder((CoreEvent)originalEvent).clearLoggingVariables().build();
    }

    private CoreEvent removeLoggingVariable(CoreEvent originalEvent, String variableName) {
        return PrivilegedEvent.builder((CoreEvent)originalEvent).removeLoggingVariable(variableName).build();
    }

    private CoreEvent setLoggingVariable(CoreEvent originalEvent, String variableName, String value) {
        return PrivilegedEvent.builder((CoreEvent)originalEvent).addLoggingVariable(variableName, value).build();
    }
}

