/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.spring.internal.beanfactory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.extension.spring.internal.util.CustomPostAuthenticationChecks;
import org.mule.extension.spring.internal.util.CustomPreAuthenticationChecks;
import org.mule.runtime.api.ioc.ObjectProvider;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.security.core.userdetails.UserCache;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.cache.NullUserCache;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.password.Pbkdf2PasswordEncoder;

public class ArtifactObjectsAwareBeanFactory
extends DefaultListableBeanFactory {
    private final transient ObjectProvider artifactObjectProvider;
    private boolean destroying = false;

    public ArtifactObjectsAwareBeanFactory(BeanFactory parentBeanFactory, ObjectProvider artifactObjectProvider) {
        super(parentBeanFactory);
        this.artifactObjectProvider = artifactObjectProvider;
    }

    public Object doResolveDependency(DependencyDescriptor descriptor, String beanName, Set<String> autowiredBeanNames, TypeConverter typeConverter) throws BeansException {
        Object springDependency = null;
        NoSuchBeanDefinitionException exception = null;
        try {
            springDependency = super.doResolveDependency(descriptor, beanName, autowiredBeanNames, typeConverter);
        }
        catch (NoSuchBeanDefinitionException e) {
            exception = e;
        }
        if (springDependency == null) {
            if (exception != null) {
                throw exception;
            }
            return this.artifactObjectProvider.getObjectByType(descriptor.getDependencyType()).orElse(null);
        }
        if (Collection.class.isAssignableFrom(descriptor.getDependencyType())) {
            Class dependencyType = descriptor.getResolvableType().getGenerics().length == 1 ? descriptor.getResolvableType().getGenerics()[0].getRawClass() : Object.class;
            Map objects = this.artifactObjectProvider.getObjectsByType(dependencyType);
            if (springDependency instanceof Collection) {
                ArrayList collectionValue = new ArrayList();
                collectionValue.addAll((Collection)springDependency);
                collectionValue.addAll(objects.values());
                return collectionValue;
            }
            return objects;
        }
        return springDependency;
    }

    protected <T> T doGetBean(String name, Class<T> requiredType, Object[] args, boolean typeCheckOnly) throws BeansException {
        String securityModel = System.getProperty("mule.security.model");
        if (securityModel != null && securityModel.startsWith("fips140-") && (name.contains(DaoAuthenticationProvider.class.getName()) || DaoAuthenticationProvider.class.equals(requiredType))) {
            return (T)ArtifactObjectsAwareBeanFactory.authenticationProvider(this.getUserDetailService(name));
        }
        if (this.containsBean(name) || !this.artifactObjectProvider.containsObject(name) || this.destroying) {
            return (T)super.doGetBean(name, requiredType, args, typeCheckOnly);
        }
        Optional optionalObj = this.artifactObjectProvider.getObject(name);
        if (!optionalObj.isPresent()) {
            throw new NoSuchBeanDefinitionException(name, String.format("No bean named '%s' available in artifact object provider", name));
        }
        Object obj = optionalObj.get();
        if (requiredType != null && !requiredType.isInstance(obj)) {
            throw new BeansException(String.format("Bean named '%s' is not of required type [%s] but was [%s]", name, requiredType.getName(), obj.getClass().getName())){};
        }
        return requiredType != null ? requiredType.cast(obj) : obj;
    }

    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        if (this.implementsLifecycle(beanDefinition)) {
            throw new BeanDefinitionStoreException(String.format("%s should not implement mule Lifecycle (Initialisable, Startable, Stoppable, Disposable)", beanName));
        }
        super.registerBeanDefinition(beanName, beanDefinition);
    }

    private boolean implementsLifecycle(BeanDefinition beanDefinition) {
        if (beanDefinition.getBeanClassName() == null) {
            return false;
        }
        try {
            Class<?> beanClass = Class.forName(beanDefinition.getBeanClassName());
            return Initialisable.class.isAssignableFrom(beanClass) || Startable.class.isAssignableFrom(beanClass) || Stoppable.class.isAssignableFrom(beanClass) || Disposable.class.isAssignableFrom(beanClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public void markForDestroy() {
        this.destroying = true;
    }

    public ObjectProvider getArtifactObjectProvider() {
        return this.artifactObjectProvider;
    }

    static DaoAuthenticationProvider authenticationProvider(UserDetailsService userDetailsService) {
        DaoAuthenticationProvider authProvider = new DaoAuthenticationProvider(ArtifactObjectsAwareBeanFactory.createDelegatingPasswordEncoder());
        authProvider.setUserDetailsService(userDetailsService);
        authProvider.setUserCache((UserCache)new NullUserCache());
        authProvider.setAuthoritiesMapper((GrantedAuthoritiesMapper)new NullAuthoritiesMapper());
        authProvider.setPreAuthenticationChecks((UserDetailsChecker)new CustomPreAuthenticationChecks());
        authProvider.setPostAuthenticationChecks((UserDetailsChecker)new CustomPostAuthenticationChecks());
        return authProvider;
    }

    static PasswordEncoder createDelegatingPasswordEncoder() {
        String encodingId = "bcrypt";
        HashMap<String, Object> encoders = new HashMap<String, Object>();
        encoders.put(encodingId, new BCryptPasswordEncoder());
        encoders.put("pbkdf2", Pbkdf2PasswordEncoder.defaultsForSpringSecurity_v5_8());
        return new DelegatingPasswordEncoder(encodingId, encoders);
    }

    protected UserDetailsService getUserDetailService(String name) {
        List propertyValues = super.getBeanDefinition(name).getPropertyValues().getPropertyValueList();
        String userServiceName = propertyValues.stream().filter(propertyValue -> "userDetailsService".equals(propertyValue.getName())).map(propertyValue -> ((RuntimeBeanReference)propertyValue.getValue()).getBeanName()).findFirst().orElse(null);
        return (UserDetailsService)super.getBean(userServiceName != null ? userServiceName : "userService");
    }
}

