/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.soapkit.internal;

import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.mule.module.soapkit.internal.SoapSubFlowAttributes;
import org.mule.module.soapkit.internal.SoapSubFlowPayload;
import org.mule.module.soapkit.internal.SoapkitConfiguration;
import org.mule.module.soapkit.internal.exception.SoapkitRouterException;
import org.mule.module.soapkit.internal.util.HttpListenerUtils;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soapkit.soap.api.server.SoapServerHandler;
import org.mule.soapkit.soap.message.EmptySoapResponse;
import org.mule.soapkit.soap.message.ImmutableSoapResponse;
import org.mule.soapkit.soap.message.SoapResponse;
import org.mule.soapkit.soap.util.Cast;
import org.mule.wsdl.parser.model.operation.OperationType;

public class DefaultSoapServerHandler
implements SoapServerHandler {
    private final CoreEvent event;
    private final SoapkitConfiguration config;
    private final StreamingHelper streamingHelper;
    private final ConfigurationComponentLocator componentLocator;
    private static final String ERROR_MISSING_FLOW = "Despite the given WSDL file configurated in configuration '%s' does contains the name '%s', there is no current flow that maps to it (the expected flow should be called '%s')";

    DefaultSoapServerHandler(CoreEvent event, SoapkitConfiguration config, StreamingHelper streamingHelper, ConfigurationComponentLocator componentLocator) {
        this.event = event;
        this.config = config;
        this.streamingHelper = streamingHelper;
        this.componentLocator = componentLocator;
    }

    public SoapResponse handle(SoapRequest request) throws ExecutionException {
        OperationType type = this.getType(request);
        try {
            Flow flow = this.findFlow(this.config, request.getOperation());
            Message message = this.buildMessage(request);
            CoreEvent requestEvent = CoreEvent.builder((CoreEvent)this.event).message(message).build();
            Event responseEvent = (Event)flow.execute((Event)requestEvent).get();
            return this.buildResponse(responseEvent, type);
        }
        catch (ExecutionException | SoapkitRouterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SoapkitRouterException(I18nMessageFactory.createStaticMessage((String)"Error Routing Event with Soap Server"), e);
        }
    }

    public Map<String, TypedValue<?>> getVariables() {
        return this.event.getVariables();
    }

    private OperationType getType(SoapRequest request) {
        try {
            return this.config.getInfo().getPortModel().getOperation(request.getOperation()).getType();
        }
        catch (ConnectionException e) {
            throw new SoapkitRouterException(I18nMessageFactory.createStaticMessage((String)"Error Getting Operation Type from Request"), e);
        }
    }

    private Message buildMessage(SoapRequest request) {
        Message.PayloadBuilder builder = Message.builder();
        TypedValue<SoapSubFlowPayload> payload = this.buildPayload(request);
        TypedValue<SoapSubFlowAttributes> attributes = this.buildAttributes(request);
        return builder.payload(payload).attributes(attributes).build();
    }

    private TypedValue<SoapSubFlowAttributes> buildAttributes(SoapRequest request) {
        SoapSubFlowAttributes attributes = new SoapSubFlowAttributes(request.getTransportHeaders());
        return this.wrap(attributes, MediaType.APPLICATION_JAVA);
    }

    private Flow findFlow(SoapkitConfiguration config, String operation) {
        String flowName = String.format("%s:\\%s", operation, config.getName());
        Optional component = this.componentLocator.find(Location.builder().globalName(flowName).build());
        return (Flow)component.orElseThrow(() -> new SoapkitRouterException(I18nMessageFactory.createStaticMessage((String)String.format(ERROR_MISSING_FLOW, config.getName(), operation, flowName))));
    }

    private SoapResponse buildResponse(Event event, OperationType type) {
        TypedValue messageAttributes = event.getMessage().getAttributes();
        MediaType contentType = this.getContentTypeFromMessage((TypedValue<Object>)messageAttributes);
        SoapSubFlowAttributes attributes = this.handleAttributes((TypedValue<Object>)messageAttributes, contentType);
        HashMap<String, String> transportAdditionalData = new HashMap<String, String>();
        HashMap<String, String> protocolHeaders = new HashMap<String, String>(attributes.getProtocolHeaders());
        String statusCode = DefaultSoapServerHandler.getStatusCode(event, this.config.getHttpStatusVarName());
        if (statusCode != null) {
            transportAdditionalData.put("statusCode", statusCode);
            protocolHeaders.put("httpStatus", statusCode);
        }
        if (OperationType.ONE_WAY.equals((Object)type)) {
            if (statusCode == null) {
                transportAdditionalData.put("statusCode", String.valueOf(HttpConstants.HttpStatus.ACCEPTED.getStatusCode()));
                protocolHeaders.put("httpStatus", String.valueOf(HttpConstants.HttpStatus.ACCEPTED.getStatusCode()));
            }
            return new EmptySoapResponse(protocolHeaders, transportAdditionalData, event.getVariables());
        }
        return new ImmutableSoapResponse(event, protocolHeaders, transportAdditionalData, contentType);
    }

    private MediaType getContentTypeFromMessage(TypedValue<Object> messageAttributes) {
        if (messageAttributes.getValue() instanceof SoapSubFlowAttributes) {
            SoapSubFlowAttributes attrs = (SoapSubFlowAttributes)messageAttributes.getValue();
            return HttpListenerUtils.getContentTypeWithCharset(attrs.getProtocolHeaders(), "Content-Type");
        }
        return MediaType.APPLICATION_XML.withCharset(Charset.defaultCharset());
    }

    private static String getStatusCode(Event event, String httpStatusVarName) {
        TypedValue statusCode = httpStatusVarName != null ? (TypedValue)event.getVariables().get(httpStatusVarName) : null;
        return statusCode == null ? null : String.valueOf(statusCode.getValue());
    }

    private SoapSubFlowAttributes handleAttributes(TypedValue<Object> attributes, MediaType contentType) {
        Map map;
        Object protocolHeaders;
        Object value = attributes.getValue();
        if (value instanceof Map && (protocolHeaders = (map = (Map)Cast.cast((Object)value)).get("responseProtocolHeaders")) instanceof Map) {
            return new SoapSubFlowAttributes((Map)Cast.cast(protocolHeaders));
        }
        ImmutableMap protocolHeaders2 = ImmutableMap.builder().put((Object)"Content-Type", (Object)contentType.toString()).build();
        return new SoapSubFlowAttributes((Map)Cast.cast((Object)protocolHeaders2));
    }

    private TypedValue<SoapSubFlowPayload> buildPayload(SoapRequest request) {
        SoapSubFlowPayload payload = new SoapSubFlowPayload(this.wrapBody(request.getContent(), MediaType.parse((String)request.getContentType())), this.wrapHeaders(request.getSoapHeaders()), this.wrapAttachments(request.getAttachments()));
        return this.wrap(payload, MediaType.APPLICATION_JAVA);
    }

    private TypedValue<InputStream> wrapBody(InputStream body, MediaType mediaType) {
        DataType dataType = DataType.builder().type(InputStream.class).mediaType(MediaType.APPLICATION_XML).charset(mediaType.getCharset().orElse(Charset.defaultCharset())).build();
        return new TypedValue(this.streamingHelper.resolveCursorProvider((Object)body), dataType);
    }

    private Map<String, TypedValue<InputStream>> wrapAttachments(Map<String, SoapAttachment> attachments) {
        ImmutableMap.Builder wrapped = ImmutableMap.builder();
        attachments.forEach((k, v) -> {
            DataType dataType = DataType.builder().type(InputStream.class).mediaType(v.getContentType()).build();
            wrapped.put(k, (Object)new TypedValue(this.streamingHelper.resolveCursorProvider((Object)v.getContent()), dataType));
        });
        return wrapped.build();
    }

    private <T> TypedValue<T> wrap(T object, MediaType mediaType) {
        return new TypedValue(object, DataType.builder().mediaType(mediaType).build());
    }

    private Map<String, TypedValue<String>> wrapHeaders(Map<String, String> headers) {
        ImmutableMap.Builder wrapped = ImmutableMap.builder();
        headers.forEach((k, v) -> wrapped.put(k, (Object)new TypedValue(v, DataType.builder().mediaType(MediaType.APPLICATION_XML).build())));
        return wrapped.build();
    }
}

