/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.routing;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.mule.extension.internal.exception.NotImplementedException;
import org.mule.extension.internal.routing.RoutingContext;
import org.mule.extension.internal.routing.RoutingKey;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class RoutingManager {
    protected final Map<RoutingKey<?, ?, ?>, Object> routeConfigurations = new ConcurrentHashMap();
    protected final Map<RoutingKey<?, ?, ?>, Function<? extends Result<?, ?>, ? extends RoutingContext>> callbacks = new ConcurrentHashMap();

    public <T, A, C> void registerListener(RoutingKey<T, A, C> routingKey, Function<Result<T, A>, RoutingContext> callback, C config) {
        if (this.callbacks.put(routingKey, callback) != null) {
            throw new IllegalStateException("Duplicated Entries");
        }
        if (config != null && this.routeConfigurations.put(routingKey, config) != null) {
            throw new IllegalStateException("Duplicated Entries");
        }
    }

    public void unregisterListenerContext(RoutingKey<?, ?, ?> routingKey) {
        this.callbacks.remove(routingKey);
        this.routeConfigurations.remove(routingKey);
    }

    public <C> C getExpansionParametersConfig(RoutingKey<?, ?, C> routingKey) {
        this.validateCallbackIsRegistered(routingKey);
        return (C)this.routeConfigurations.get(routingKey);
    }

    public <T, A> RoutingContext route(RoutingKey<T, A, ?> routingKey, Result<T, A> sourceInput) {
        this.validateCallbackIsRegistered(routingKey);
        return this.callbacks.get(routingKey).apply(sourceInput);
    }

    private void validateCallbackIsRegistered(RoutingKey<?, ?, ?> routingKey) {
        if (this.callbacks.get(routingKey) == null) {
            throw new NotImplementedException(String.format("Missing flow implementation for key: {%s}", routingKey.toString()));
        }
    }
}

