/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.model.builders;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.extension.api.routing.ODataRequestAttributes;
import org.mule.runtime.api.util.MultiMap;

public class ODataRequestAttributesBuilder {
    private String entityTypeName;
    private Map<String, String> entityTypeKeys;
    private Map<String, String> systemQueryOptions;
    private MultiMap<String, String> customQueryOptions;
    private List<String> entityTypeFields;
    private String correlationId;

    private ODataRequestAttributesBuilder() {
    }

    public static ODataRequestAttributesBuilder builder() {
        return new ODataRequestAttributesBuilder();
    }

    public ODataRequestAttributesBuilder withEntityTypeName(String entityTypeName) {
        this.entityTypeName = entityTypeName;
        return this;
    }

    public ODataRequestAttributesBuilder withEntityTypeFields(List<String> entityTypeFields) {
        this.entityTypeFields = entityTypeFields;
        return this;
    }

    public ODataRequestAttributesBuilder withEntityTypeKeys(Map<String, String> entityTypeKeys) {
        this.entityTypeKeys = entityTypeKeys;
        return this;
    }

    public ODataRequestAttributesBuilder withSystemQueryOptions(Map<String, String> systemQueryOptions) {
        this.systemQueryOptions = systemQueryOptions;
        return this;
    }

    public ODataRequestAttributesBuilder withCustomQueryOptions(MultiMap<String, String> customQueryOptions) {
        this.customQueryOptions = customQueryOptions;
        return this;
    }

    public ODataRequestAttributesBuilder withCorrelationId(String correlationId) {
        if (!StringUtils.isBlank((CharSequence)correlationId)) {
            this.correlationId = correlationId;
        }
        return this;
    }

    public ODataRequestAttributes build() {
        return new ODataRequestAttributes(this.entityTypeName, this.entityTypeFields, this.entityTypeKeys, this.systemQueryOptions, this.customQueryOptions, this.correlationId);
    }
}

