/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.datasense.provider;

import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.mule.extension.internal.datasense.provider.AbstractMetadataProvider;
import org.mule.extension.internal.datasense.provider.CollectionTypeMetadataProvider;
import org.mule.extension.internal.datasense.provider.EnumTypeMetadataProvider;
import org.mule.extension.internal.datasense.provider.MetadataProvider;
import org.mule.extension.internal.datasense.provider.PrimitiveTypeMetadataProvider;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;

public class StructuredTypeMetadataProvider
extends AbstractMetadataProvider {
    private static final int MAX_DEPTH_ALLOWED = 2;
    private int depth;
    private EdmStructuredType structuredType;

    public StructuredTypeMetadataProvider(EdmStructuredType structuredType, MetadataContext metadataContext) {
        super(null, metadataContext);
        this.structuredType = structuredType;
        this.depth = 0;
    }

    private StructuredTypeMetadataProvider(EdmStructuredType structuredType, EdmElement parentElement, int depth, MetadataContext metadataContext) {
        super(parentElement, metadataContext);
        this.structuredType = structuredType;
        this.depth = depth;
    }

    @Override
    public MetadataType getMetadataType() throws MetadataResolvingException {
        ObjectTypeBuilder objectTypeBuilder = this.typeBuilder.objectType();
        for (String propertyName : this.structuredType.getPropertyNames()) {
            EdmProperty structuralProperty = this.structuredType.getStructuralProperty(propertyName);
            this.addPropertyMetadataToBuilder(objectTypeBuilder, (EdmElement)structuralProperty, structuralProperty.isNullable());
        }
        for (String navPropertyName : this.structuredType.getNavigationPropertyNames()) {
            EdmNavigationProperty navigationProperty = this.structuredType.getNavigationProperty(navPropertyName);
            this.addPropertyMetadataToBuilder(objectTypeBuilder, (EdmElement)navigationProperty, navigationProperty.isNullable());
        }
        return objectTypeBuilder.build();
    }

    private void addPropertyMetadataToBuilder(ObjectTypeBuilder objectTypeBuilder, EdmElement entityElement, boolean isNullable) throws MetadataResolvingException {
        MetadataProvider metadataProvider = this.getMetadataProvider(entityElement.getType(), entityElement, this.metadataContext);
        if (entityElement.isCollection()) {
            metadataProvider = new CollectionTypeMetadataProvider(metadataProvider, this.metadataContext);
        }
        objectTypeBuilder.addField().key(entityElement.getName()).required(!isNullable).value(metadataProvider.getMetadataType()).build();
    }

    protected MetadataProvider getMetadataProvider(EdmType type, EdmElement parentElement, MetadataContext metadataContext) {
        switch (type.getKind()) {
            case ENTITY: 
            case COMPLEX: 
            case NAVIGATION: {
                return this.depth == 2 ? new LeafObjectTypeMetadataProvider(parentElement, metadataContext) : new StructuredTypeMetadataProvider((EdmStructuredType)type, parentElement, this.depth + 1, metadataContext);
            }
            case ENUM: {
                return new EnumTypeMetadataProvider((EdmEnumType)type, parentElement, metadataContext);
            }
            case PRIMITIVE: {
                return new PrimitiveTypeMetadataProvider((EdmPrimitiveType)type, parentElement, metadataContext);
            }
        }
        throw new IllegalStateException("Unexpected value: " + type.getKind());
    }

    private static class LeafObjectTypeMetadataProvider
    extends AbstractMetadataProvider {
        protected LeafObjectTypeMetadataProvider(EdmElement parentElement, MetadataContext metadataContext) {
            super(parentElement, metadataContext);
        }

        @Override
        public MetadataType getMetadataType() throws MetadataResolvingException {
            return this.typeBuilder.objectType().build();
        }
    }
}

