/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.transformation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.core.uri.parser.OrderByParser;
import org.apache.olingo.server.core.uri.parser.UriTokenizer;
import org.mule.extension.api.transformation.SQLLimitRows;
import org.mule.extension.internal.exception.SQLTransformationException;
import org.mule.extension.internal.transformation.DelimitIdentifiers;
import org.mule.extension.internal.transformation.OrderByExpressionVisitor;
import org.mule.extension.internal.transformation.SQLPreparedStatementBuilder;

public class PaginationBuilder {
    private Integer pageSize;
    private Integer top;
    private Integer skiptoken;
    private Integer skip;
    private EdmEntityType entityType;
    private SQLLimitRows limitRows;
    private String orderBy;
    private OrderByParser orderByParser;
    private final DelimitIdentifiers delimitIdentifiers;
    private static final Map<SQLLimitRows, BiFunction<Integer, SQLPreparedStatementBuilder, String>> rowsLimitSentences = new HashMap<SQLLimitRows, BiFunction<Integer, SQLPreparedStatementBuilder, String>>(){
        {
            this.put(SQLLimitRows.LIMIT, (limit, sqlPreparedStatementBuilder) -> " LIMIT " + sqlPreparedStatementBuilder.getParameterKey(limit));
            this.put(SQLLimitRows.FETCH_NEXT_ROWS_ONLY, (limit, sqlPreparedStatementBuilder) -> " FETCH NEXT " + sqlPreparedStatementBuilder.getParameterKey(limit) + " ROWS ONLY");
        }
    };
    private static final Map<SQLLimitRows, BiFunction<String, String, String>> offsetPositions = new HashMap<SQLLimitRows, BiFunction<String, String, String>>(){
        {
            this.put(SQLLimitRows.LIMIT, (limitSentence, offsetSentence) -> limitSentence + offsetSentence);
            this.put(SQLLimitRows.FETCH_NEXT_ROWS_ONLY, (limitSentence, offsetSentence) -> offsetSentence + limitSentence);
        }
    };
    private final Map<SQLLimitRows, BiFunction<Integer, SQLPreparedStatementBuilder, String>> offsetSentences = new HashMap<SQLLimitRows, BiFunction<Integer, SQLPreparedStatementBuilder, String>>(){
        {
            this.put(SQLLimitRows.LIMIT, (value, sqlPreparedStatementBuilder) -> " OFFSET " + sqlPreparedStatementBuilder.getParameterKey(value));
            this.put(SQLLimitRows.FETCH_NEXT_ROWS_ONLY, (value, sqlPreparedStatementBuilder) -> " OFFSET " + sqlPreparedStatementBuilder.getParameterKey(value) + " ROWS");
        }
    };

    public PaginationBuilder(DelimitIdentifiers delimitIdentifiers) {
        this.delimitIdentifiers = delimitIdentifiers;
    }

    public PaginationBuilder withPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public PaginationBuilder withTop(Integer top) {
        this.top = top;
        return this;
    }

    public PaginationBuilder withSkipToken(Integer skipToken) {
        this.skiptoken = skipToken;
        return this;
    }

    public PaginationBuilder withSkip(Integer skip) {
        this.skip = skip;
        return this;
    }

    public PaginationBuilder withEntityType(EdmEntityType entityType) {
        this.entityType = entityType;
        return this;
    }

    public PaginationBuilder withLimitRows(SQLLimitRows limitRows) {
        this.limitRows = limitRows;
        return this;
    }

    public PaginationBuilder withOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public PaginationBuilder withOrderByParser(OrderByParser orderByParser) {
        this.orderByParser = orderByParser;
        return this;
    }

    public String build(SQLPreparedStatementBuilder sqlPreparedStatementBuilder) {
        return this.build(sqlPreparedStatementBuilder, this.generateOrderBy(this.orderBy), this.generateLimit(sqlPreparedStatementBuilder), this.generateOffset(sqlPreparedStatementBuilder));
    }

    private String build(SQLPreparedStatementBuilder sqlPreparedStatementBuilder, String orderBy, String limit, String offset) {
        BiFunction<String, String, String> offsetOrder = offsetPositions.get((Object)this.limitRows);
        if (SQLLimitRows.LIMIT.equals((Object)this.limitRows) || limit.isEmpty()) {
            return orderBy + offsetOrder.apply(limit, offset);
        }
        if (offset.isEmpty()) {
            offset = this.offsetSentences.get((Object)this.limitRows).apply(0, sqlPreparedStatementBuilder);
        }
        if (orderBy.isEmpty()) {
            orderBy = this.generateOrderBy(String.join((CharSequence)",", this.entityType.getKeyPredicateNames()));
        }
        return orderBy + offsetOrder.apply(limit, offset);
    }

    private Optional<Integer> getLimit() {
        return Optional.ofNullable(this.pageSize != null ? this.pageSize : this.top);
    }

    private Optional<Integer> getOffset() {
        return Optional.ofNullable(this.pageSize != null ? this.skiptoken : this.skip);
    }

    private String generateOffset(SQLPreparedStatementBuilder sqlPreparedStatementBuilder) {
        return this.getOffset().map(value -> this.offsetSentences.get((Object)this.limitRows).apply((Integer)value, sqlPreparedStatementBuilder)).orElse("");
    }

    private String generateLimit(SQLPreparedStatementBuilder sqlPreparedStatementBuilder) {
        return this.getLimit().map(limit -> rowsLimitSentences.get((Object)this.limitRows).apply((Integer)limit, sqlPreparedStatementBuilder)).orElse("");
    }

    private String generateOrderBy(String orderBy) {
        return orderBy == null ? "" : " ORDER BY " + this.getSQLOrderBy(orderBy);
    }

    private String getSQLOrderBy(String rawOrderBy) {
        try {
            UriTokenizer orderByTokenizer = new UriTokenizer(rawOrderBy);
            List orders = this.orderByParser.parse(orderByTokenizer, (EdmStructuredType)this.entityType, Collections.emptyList(), Collections.emptyMap()).getOrders();
            OrderByExpressionVisitor visitor = new OrderByExpressionVisitor(this.delimitIdentifiers);
            List ordersString = orders.stream().map(orderByItem -> {
                try {
                    String primitivePropertyName = (String)orderByItem.getExpression().accept((ExpressionVisitor)visitor);
                    String ordering = orderByItem.isDescending() ? "DESC" : "ASC";
                    return primitivePropertyName + " " + ordering;
                }
                catch (Exception e) {
                    throw new SQLTransformationException("An error occurred while generating SQL transformation for $orderby", e);
                }
            }).collect(Collectors.toList());
            return String.join((CharSequence)", ", ordersString);
        }
        catch (Exception e) {
            throw new SQLTransformationException("An error occurred while generating SQL transformation for $orderby", e);
        }
    }
}

