/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.datasense;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmNavigationPropertyBinding;
import org.mule.extension.internal.ODataConfig;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;

public abstract class BaseKeyResolver
implements TypeKeysResolver {
    protected static final String SLASH_DELIMITER = "/";

    public Set<MetadataKey> getKeys(MetadataContext metadataContext) throws MetadataResolvingException {
        HashSet<MetadataKey> keys = new HashSet<MetadataKey>();
        ODataConfig config = (ODataConfig)metadataContext.getConfig().orElseThrow(() -> new MetadataResolvingException("Invalid Configuration", FailureCode.INVALID_CONFIGURATION));
        Edm edm = config.getHandler().getEdm();
        List entitySets = edm.getEntityContainer().getEntitySets();
        List<MetadataKeyBuilder> httpMethodKeys = this.getHttpMethodKeys();
        List<MetadataKeyBuilder> navigationPathMetadataKeys = this.getNavigationPathMetadataKeys(entitySets);
        for (MetadataKeyBuilder httpMethodKey : httpMethodKeys) {
            navigationPathMetadataKeys.forEach(key -> httpMethodKey.withChild(key));
        }
        httpMethodKeys.stream().map(MetadataKeyBuilder::build).forEach(keys::add);
        return keys;
    }

    protected abstract List<MetadataKeyBuilder> getHttpMethodKeys();

    private List<MetadataKeyBuilder> getNavigationPathMetadataKeys(List<EdmEntitySet> entitySets) {
        ArrayList<MetadataKeyBuilder> navigationPathKeys = new ArrayList<MetadataKeyBuilder>();
        for (EdmEntitySet entitySet : entitySets) {
            String entitySetName = entitySet.getName();
            navigationPathKeys.add(MetadataKeyBuilder.newKey((String)(SLASH_DELIMITER + entitySetName)));
            for (EdmNavigationPropertyBinding navPropertyBinding : entitySet.getNavigationPropertyBindings()) {
                navigationPathKeys.add(MetadataKeyBuilder.newKey((String)(SLASH_DELIMITER + entitySet.getName() + SLASH_DELIMITER + navPropertyBinding.getPath())));
            }
        }
        return navigationPathKeys;
    }
}

