/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.utils;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.core.edm.EdmEntityTypeImpl;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.queryoption.CustomQueryOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOption;
import org.apache.olingo.server.core.uri.UriInfoImpl;
import org.apache.olingo.server.core.uri.UriResourceEntitySetImpl;
import org.apache.olingo.server.core.uri.UriResourceNavigationPropertyImpl;
import org.mule.extension.api.constants.HttpMethod;
import org.mule.extension.api.routing.RouteOutputAttributes;
import org.mule.extension.internal.model.APIKitODataResponse;
import org.mule.extension.internal.model.builders.RouteOutputAttributesBuilder;
import org.mule.extension.internal.routing.RoutingKey;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class OlingoUtils {
    public static APIKitODataResponse getAPIKitResponse(ODataResponse response) {
        return (APIKitODataResponse)response;
    }

    public static Result<InputStream, RouteOutputAttributes> toResult(ODataResponse response) {
        APIKitODataResponse apikitResponse = OlingoUtils.getAPIKitResponse(response);
        return Result.builder().output((Object)response.getContent()).attributes((Object)OlingoUtils.getOutputAttributes(apikitResponse)).mediaType(OlingoUtils.getContentMediaType(response)).build();
    }

    public static Optional<EdmEntityType> getReturnType(UriInfo uriInfo) {
        UriResource uriResource = OlingoUtils.getUriLastResourcePart(uriInfo);
        return Optional.ofNullable(OlingoUtils.getEdmEntityType(uriInfo.getUriResourceParts(), uriResource));
    }

    public static UriResource getUriLastResourcePart(UriInfo uriInfo) {
        return uriInfo instanceof UriInfoImpl ? ((UriInfoImpl)uriInfo).getLastResourcePart() : (UriResource)uriInfo.getUriResourceParts().get(uriInfo.getUriResourceParts().size() - 1);
    }

    public static Optional<String> getEntitySetName(UriInfo uriInfo) {
        UriResource uriResource = OlingoUtils.getEntityContainerUriResource(uriInfo.getUriResourceParts());
        if (uriResource == null) {
            return Optional.empty();
        }
        if (uriResource instanceof UriResourceEntitySetImpl) {
            UriResourceEntitySetImpl uriResourceEntitySet = (UriResourceEntitySetImpl)uriResource;
            return Optional.ofNullable(uriResourceEntitySet.getEntitySet().getName());
        }
        if (uriResource instanceof UriResourceNavigationPropertyImpl) {
            UriResourceNavigationPropertyImpl uriResourceNavigationProperty = (UriResourceNavigationPropertyImpl)uriResource;
            return Optional.ofNullable(uriResourceNavigationProperty.getProperty().getName());
        }
        return Optional.empty();
    }

    public static Map<String, String> getEntityTypeKeysFromUriParameters(List<UriResource> uriResources) {
        HashMap<String, String> entityTypeKeys = new HashMap<String, String>();
        uriResources.forEach(value -> {
            if (value instanceof UriResourceEntitySet) {
                UriResourceEntitySet entitySet = (UriResourceEntitySet)value;
                entityTypeKeys.putAll(entitySet.getKeyPredicates().stream().collect(Collectors.toMap(uriParameter -> uriParameter.getName(), uriParameter -> uriParameter.getText())));
            } else if (value instanceof UriResourceNavigation) {
                UriResourceNavigation navigation = (UriResourceNavigation)value;
                entityTypeKeys.putAll(navigation.getKeyPredicates().stream().collect(Collectors.toMap(uriParameter -> uriParameter.getName(), uriParameter -> uriParameter.getText())));
            }
        });
        return entityTypeKeys;
    }

    public static List<String> getEntityTypeFields(EdmEntityType entityType) {
        if (entityType == null) {
            return new ArrayList<String>();
        }
        Map properties = ((EdmEntityTypeImpl)entityType).getProperties();
        return new ArrayList<String>(properties.keySet());
    }

    public static String getUriPath(List<UriResource> parts) {
        StringBuilder stringBuilder = new StringBuilder();
        parts.forEach(value -> {
            if (UriResourceKind.entitySet.equals((Object)value.getKind()) || UriResourceKind.navigationProperty.equals((Object)value.getKind())) {
                stringBuilder.append("/");
                stringBuilder.append(value.getSegmentValue());
            }
        });
        return stringBuilder.toString();
    }

    public static RoutingKey getRoutingKey(ODataRequest request, UriInfo uriInfo) {
        return new RoutingKey(HttpMethod.valueOf(request.getMethod().name()), OlingoUtils.getUriPath(uriInfo.getUriResourceParts()));
    }

    public static Map<String, String> getSystemQueryOptions(List<SystemQueryOption> systemQueryOptionOptions) {
        HashMap<String, String> options = new HashMap<String, String>();
        systemQueryOptionOptions.forEach(sqo -> options.put(sqo.getName().substring(1), sqo.getText()));
        return options;
    }

    public static MultiMap<String, String> getCustomQueryOptions(List<CustomQueryOption> customQueryOptions) {
        MultiMap options = new MultiMap();
        customQueryOptions.forEach(cqo -> {
            String cfr_ignored_0 = (String)options.put((Object)cqo.getName(), (Object)cqo.getText());
        });
        return options;
    }

    public static Optional<String> getEntityTypeName(EdmEntityType entityType) {
        return entityType == null ? Optional.empty() : Optional.ofNullable(entityType.getName());
    }

    private static RouteOutputAttributes getOutputAttributes(APIKitODataResponse response) {
        return RouteOutputAttributesBuilder.builder().withStatusCode(response.getStatusCode()).withMultipleEntryHeadersMap(response.getAllHeaders()).withFlowAttributes(response.getFlowAttributes()).build();
    }

    private static MediaType getContentMediaType(ODataResponse response) {
        String contentType = response.getHeader("Content-Type");
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{contentType}) ? MediaType.parse((String)contentType) : MediaType.ANY;
    }

    private static EdmEntityType getEdmEntityType(List<UriResource> uriResourceParts, UriResource resourcePart) {
        EdmType edmType = OlingoUtils.getUriResourcePartType(resourcePart);
        if (edmType == null) {
            return null;
        }
        EdmTypeKind typeKind = edmType.getKind();
        if (EdmTypeKind.ENTITY.equals((Object)typeKind)) {
            return (EdmEntityType)edmType;
        }
        if (EdmTypeKind.PRIMITIVE.equals((Object)typeKind) || EdmTypeKind.COMPLEX.equals((Object)typeKind)) {
            int uriResourcePartsSize = uriResourceParts.size();
            return OlingoUtils.getEdmEntityType(uriResourceParts.subList(0, uriResourcePartsSize - 1), uriResourceParts.get(uriResourcePartsSize - 1));
        }
        return null;
    }

    private static UriResource getEntityContainerUriResource(List<UriResource> uriResourceParts) {
        int uriResourcePartsSize = uriResourceParts.size();
        if (uriResourcePartsSize == 0) {
            return null;
        }
        UriResource uriResource = uriResourceParts.get(uriResourcePartsSize - 1);
        if (uriResource instanceof UriResourceEntitySetImpl || uriResource instanceof UriResourceNavigationPropertyImpl) {
            return uriResource;
        }
        return OlingoUtils.getEntityContainerUriResource(uriResourceParts.subList(0, uriResourcePartsSize - 1));
    }

    private static EdmType getUriResourcePartType(UriResource resourcePart) {
        if (resourcePart instanceof UriResourcePartTyped) {
            return ((UriResourcePartTyped)resourcePart).getType();
        }
        return null;
    }
}

