/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.sources;

import javax.inject.Inject;
import org.mule.extension.internal.ODataConfig;
import org.mule.extension.internal.routing.DefaultRoutingContext;
import org.mule.extension.internal.routing.RoutingKey;
import org.mule.extension.internal.routing.RoutingManager;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.runtime.source.SourceCompletionCallback;
import org.mule.runtime.extension.api.runtime.source.SourceResult;

public abstract class BaseSource<T, A, M extends RoutingManager>
extends Source<T, A> {
    protected final String ROUTING_CONTEXT_KEY = "routingContext";
    @Config
    protected ODataConfig odataConfig;
    @MetadataKeyId
    @ParameterGroup(name="routingKey")
    protected RoutingKey routingKey;
    @Inject
    protected M routingManager;

    @OnError
    public void onError(Error error, SourceCallbackContext callbackContext, SourceCompletionCallback completionCallback) {
        DefaultRoutingContext routingContext = this.getRoutingContext(callbackContext);
        routingContext.setSourceCompletionCallback(completionCallback);
        routingContext.getFlowCompletableResponse().completeExceptionally(error.getCause());
    }

    public void onStop() {
        ((RoutingManager)this.routingManager).unregisterListenerCallback(this.routingKey);
    }

    @OnTerminate
    public void onTerminate(SourceResult sourceResult) {
        DefaultRoutingContext routingContext = this.getRoutingContext(sourceResult.getSourceCallbackContext());
        if (routingContext != null) {
            sourceResult.getInvocationError().ifPresent(error -> routingContext.getFlowCompletableResponse().completeExceptionally(error.getCause()));
            sourceResult.getResponseError().ifPresent(error -> routingContext.getFlowCompletableResponse().completeExceptionally(error.getCause()));
        }
    }

    protected DefaultRoutingContext getRoutingContext(SourceCallbackContext callbackContext) {
        return (DefaultRoutingContext)callbackContext.getVariable("routingContext").orElseThrow(() -> new IllegalStateException("Routing context not found"));
    }
}

