/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.datasense;

import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.mule.extension.api.constants.HttpMethod;
import org.mule.extension.internal.ODataConfig;
import org.mule.extension.internal.datasense.provider.CollectionTypeMetadataProvider;
import org.mule.extension.internal.datasense.provider.MetadataProvider;
import org.mule.extension.internal.datasense.provider.StructuredTypeMetadataProvider;
import org.mule.extension.internal.routing.RoutingKey;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;

public abstract class EntityResolver {
    private static final String SLASH_DELIMITER = "/";

    protected void validateProvidedKey(RoutingKey routingKey) throws MetadataResolvingException {
        if (routingKey == null) {
            throw new MetadataResolvingException("Invalid Key provided.", FailureCode.INVALID_METADATA_KEY);
        }
        this.validateMethod(routingKey.getMethod());
        this.validatePath(routingKey.getPath());
    }

    protected void validateMethod(HttpMethod method) throws MetadataResolvingException {
        if (method == null) {
            throw new MetadataResolvingException("Invalid Method provided.", FailureCode.INVALID_METADATA_KEY);
        }
    }

    protected void validatePath(String path) throws MetadataResolvingException {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new MetadataResolvingException("Invalid Navigation Path provided.", FailureCode.INVALID_METADATA_KEY);
        }
        if (StringUtils.isNotBlank((CharSequence)path) && !path.startsWith(SLASH_DELIMITER)) {
            throw new MetadataResolvingException("Invalid Navigation Path provided. Path has to start with '/'.", FailureCode.INVALID_METADATA_KEY);
        }
    }

    protected EdmEntitySet getTargetEntitySet(Edm edm, String navigationPath) {
        EdmEntityContainer entityContainer = edm.getEntityContainer();
        String path = navigationPath.startsWith(SLASH_DELIMITER) ? navigationPath.substring(1) : navigationPath;
        String[] pathEntries = path.split(SLASH_DELIMITER);
        if (pathEntries.length == 0) {
            return null;
        }
        EdmEntitySet entitySet = entityContainer.getEntitySet(pathEntries[0]);
        if (entitySet == null || pathEntries.length == 1) {
            return entitySet;
        }
        return this.getTargetEntitySetFromNavigationBinding(pathEntries, 1, entitySet, entityContainer);
    }

    protected EdmEntitySet getTargetEntitySetFromNavigationBinding(String[] pathEntries, int index, EdmEntitySet entitySet, EdmEntityContainer entityContainer) {
        if (index == pathEntries.length || entitySet == null) {
            return entitySet;
        }
        String pathEntry = pathEntries[index];
        for (EdmNavigationPropertyBinding propertyBinding : entitySet.getNavigationPropertyBindings()) {
            String navigationPath = propertyBinding.getPath();
            String[] navigationEntries = navigationPath.split(SLASH_DELIMITER);
            int navigationIndex = index;
            for (String navigationEntry : navigationEntries) {
                if (!navigationEntry.equals(pathEntry)) continue;
                ++navigationIndex;
            }
            if (navigationIndex <= index) continue;
            return this.getTargetEntitySetFromNavigationBinding(pathEntries, navigationIndex, entityContainer.getEntitySet(propertyBinding.getTarget()), entityContainer);
        }
        return null;
    }

    protected MetadataProvider getEntityMetadataProvider(MetadataContext metadataContext, RoutingKey routingKey) throws MetadataResolvingException {
        ODataConfig config = (ODataConfig)metadataContext.getConfig().orElseThrow(() -> new MetadataResolvingException("Invalid Configuration.", FailureCode.INVALID_CONFIGURATION));
        EdmEntitySet entitySet = this.getTargetEntitySet(config.getHandler().getEdm(), routingKey.getPath());
        if (entitySet == null) {
            throw new MetadataResolvingException("Invalid Navigation Path provided. Check that the navigation exists.", FailureCode.INVALID_METADATA_KEY);
        }
        return new StructuredTypeMetadataProvider((EdmStructuredType)entitySet.getEntityType(), metadataContext);
    }

    protected MetadataType getEntityMetadataType(MetadataContext metadataContext, RoutingKey routingKey) throws MetadataResolvingException {
        return this.getEntityMetadataProvider(metadataContext, routingKey).getMetadataType();
    }

    protected MetadataType getEntityCollectionMetadataType(MetadataContext metadataContext, RoutingKey routingKey) throws MetadataResolvingException {
        return new CollectionTypeMetadataProvider(this.getEntityMetadataProvider(metadataContext, routingKey), metadataContext).getMetadataType();
    }
}

