/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.oauth2.internal.authorizationcode.state;

import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.mule.extension.oauth2.internal.service.OAuthContextServiceAdapter;
import org.mule.runtime.api.lock.LockFactory;

public class ConfigOAuthContext {
    private final LockFactory lockFactory;
    private final String configName;
    private final Map<String, Object> oauthContextStore;

    public ConfigOAuthContext(LockFactory lockFactory, Map<String, Object> objectStore, String configName) {
        this.lockFactory = lockFactory;
        this.oauthContextStore = objectStore;
        this.configName = configName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getContextForResourceOwner(String resourceOwnerId) {
        Object resourceOwnerOAuthContext = null;
        if (!this.oauthContextStore.containsKey(resourceOwnerId)) {
            Lock lock = OAuthContextServiceAdapter.createRefreshUserOAuthContextLock(this.configName, this.lockFactory, resourceOwnerId);
            lock.lock();
            try {
                if (!this.oauthContextStore.containsKey(resourceOwnerId)) {
                    resourceOwnerOAuthContext = OAuthContextServiceAdapter.createResourceOwnerOAuthContext(resourceOwnerId, this.configName, this.lockFactory);
                    this.oauthContextStore.put(resourceOwnerId, resourceOwnerOAuthContext);
                }
            }
            finally {
                lock.unlock();
            }
        }
        if (resourceOwnerOAuthContext == null) {
            resourceOwnerOAuthContext = OAuthContextServiceAdapter.migrateContextIfNeeded(this.oauthContextStore.get(resourceOwnerId), this.configName, this.lockFactory);
        }
        return resourceOwnerOAuthContext;
    }

    public void updateResourceOwnerOAuthContext(Object resourceOwnerOAuthContext) {
        Lock resourceOwnerContextLock = OAuthContextServiceAdapter.getRefreshUserOAuthContextLock(resourceOwnerOAuthContext, this.configName, this.lockFactory);
        resourceOwnerContextLock.lock();
        try {
            this.oauthContextStore.put(OAuthContextServiceAdapter.getResourceOwnerId(resourceOwnerOAuthContext), resourceOwnerOAuthContext);
        }
        finally {
            resourceOwnerContextLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearContextForResourceOwner(String resourceOwnerId) {
        Object resourceOwnerOAuthContext = this.getContextForResourceOwner(resourceOwnerId);
        if (resourceOwnerOAuthContext != null) {
            Lock resourceOwnerContextLock = OAuthContextServiceAdapter.getRefreshUserOAuthContextLock(resourceOwnerOAuthContext, this.configName, this.lockFactory);
            resourceOwnerContextLock.lock();
            try {
                this.oauthContextStore.remove(resourceOwnerId);
            }
            finally {
                resourceOwnerContextLock.unlock();
            }
        }
    }
}

