/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.oauth2.internal;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.extension.http.api.request.proxy.HttpProxyConfig;
import org.mule.extension.oauth2.api.tokenmanager.TokenManagerConfig;
import org.mule.extension.oauth2.internal.DeferredExpressionResolver;
import org.mule.extension.oauth2.internal.OAuthUtils;
import org.mule.extension.oauth2.internal.ParameterExtractor;
import org.mule.extension.oauth2.internal.service.OAuthContextServiceAdapter;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.builder.OAuthDancerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGrantType
implements HttpRequestAuthentication,
Lifecycle {
    private final AtomicInteger initializations = new AtomicInteger();
    private final AtomicInteger starts = new AtomicInteger();
    private final Object initializationLock = new Object();
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGrantType.class);
    private static final String ACCESS_TOKEN_EXPRESSION = "#[payload.access_token]";
    private static final String REFRESH_TOKEN_EXPRESSION = "#[payload.refresh_token]";
    private static final String EXPIRATION_TIME_EXPRESSION = "#[payload.expires_in]";
    private static final String PAYLOAD = "payload";
    @Inject
    protected MuleContext muleContext;
    @Inject
    protected LockFactory lockFactory;
    @Inject
    protected MuleExpressionLanguage expressionEvaluator;
    protected DeferredExpressionResolver resolver;
    @Parameter
    private String clientId;
    @Parameter
    private String clientSecret;
    @Parameter
    @Optional
    private String scopes;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    protected TokenManagerConfig tokenManager;
    @Parameter
    private String tokenUrl;
    @Parameter
    @Optional(defaultValue="#[payload.access_token]")
    protected Literal<String> responseAccessToken;
    @Parameter
    @Optional(defaultValue="#[payload.refresh_token]")
    protected Literal<String> responseRefreshToken;
    @Parameter
    @Optional(defaultValue="#[payload.expires_in]")
    protected Literal<String> responseExpiresIn;
    @Parameter
    @Optional
    protected List<ParameterExtractor> customParameterExtractors;
    @Parameter
    @Optional(defaultValue="#[attributes.statusCode == 401 or attributes.statusCode == 403]")
    private Literal<Boolean> refreshTokenWhen;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="TLS Configuration")
    @Placement(tab="TLS")
    private TlsContextFactory tlsContext;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private HttpProxyConfig proxyConfig;
    @DefaultEncoding
    private String encoding;
    @Inject
    protected OAuthService oAuthService;
    private boolean defaultTokenManager;
    private boolean readsResponseBody;

    protected void initTokenManager() throws InitialisationException {
        if (this.tokenManager == null) {
            this.tokenManager = TokenManagerConfig.createDefault();
            this.defaultTokenManager = true;
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.tokenManager, (MuleContext)this.muleContext);
    }

    protected OAuthDancerBuilder configureBaseDancer(OAuthDancerBuilder dancerBuilder) throws InitialisationException {
        TlsContextFactory contextFactory = this.getTlsContextFactory();
        if (contextFactory != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.getTlsContextFactory());
        }
        dancerBuilder.tokenUrl(this.tokenUrl, contextFactory, (ProxyConfig)this.proxyConfig);
        dancerBuilder = OAuthContextServiceAdapter.dancerName(dancerBuilder, this.tokenManager.getName());
        dancerBuilder.scopes(this.getScopes()).encoding(Charset.forName(this.encoding)).responseAccessTokenExpr(this.resolver.getExpression(this.getResponseAccessToken())).responseRefreshTokenExpr(this.resolver.getExpression(this.getResponseRefreshToken())).responseExpiresInExpr(this.resolver.getExpression(this.getResponseExpiresIn())).customParametersExtractorsExprs(this.getCustomParameterExtractors().stream().collect(Collectors.toMap(extractor -> extractor.getParamName(), extractor -> this.resolver.getExpression(extractor.getValue()))));
        return dancerBuilder;
    }

    public abstract Object getDancer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialise() throws InitialisationException {
        Object object = this.initializationLock;
        synchronized (object) {
            if (this.initializations.get() > 0) {
                return;
            }
            this.resolver = new DeferredExpressionResolver(this.expressionEvaluator);
            this.readsResponseBody = this.refreshTokenWhen.getLiteralValue().map(expression -> expression.startsWith("#[") && expression.contains(PAYLOAD)).orElse(Boolean.FALSE);
            this.doInitialize();
            this.initializations.incrementAndGet();
        }
    }

    protected void doInitialize() throws InitialisationException {
    }

    public final void start() throws MuleException {
        if (this.starts.getAndIncrement() > 0) {
            return;
        }
        try {
            LifecycleUtils.startIfNeeded((Object)this.tokenManager);
            LifecycleUtils.startIfNeeded((Object)this.getDancer());
        }
        catch (Throwable t) {
            this.starts.getAndDecrement();
            throw t;
        }
    }

    public final void stop() throws MuleException {
        if (this.starts.decrementAndGet() > 0) {
            return;
        }
        try {
            LifecycleUtils.stopIfNeeded((Object)this.getDancer());
        }
        catch (Throwable t) {
            this.starts.incrementAndGet();
            throw t;
        }
    }

    public final void dispose() {
        if (this.initializations.decrementAndGet() > 0) {
            return;
        }
        try {
            LifecycleUtils.disposeIfNeeded((Object)this.getDancer(), (Logger)LOGGER);
        }
        catch (Throwable t) {
            this.initializations.incrementAndGet();
            throw t;
        }
    }

    protected String buildAuthorizationHeaderContent(String accessToken) {
        return "Bearer " + accessToken;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractGrantType) {
            AbstractGrantType other = (AbstractGrantType)obj;
            return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.clientSecret, other.clientSecret) && Objects.equals(this.scopes, other.scopes) && (Objects.equals(this.tokenManager, other.tokenManager) || this.isDefaultTokenManager() && other.isDefaultTokenManager()) && Objects.equals(this.tokenUrl, other.tokenUrl) && OAuthUtils.literalEquals(this.responseAccessToken, other.responseAccessToken) && OAuthUtils.literalEquals(this.responseRefreshToken, other.responseRefreshToken) && OAuthUtils.literalEquals(this.responseExpiresIn, other.responseExpiresIn) && Objects.equals(this.customParameterExtractors, other.customParameterExtractors) && OAuthUtils.literalEquals(this.refreshTokenWhen, other.refreshTokenWhen) && Objects.equals(this.tlsContext, other.tlsContext) && Objects.equals(this.proxyConfig, other.proxyConfig);
        }
        return false;
    }

    public int hashCode() {
        return 31 * Objects.hash(this.clientId, this.clientSecret, this.scopes, this.tokenManager, this.tokenUrl, this.customParameterExtractors, this.tlsContext, this.proxyConfig) * OAuthUtils.literalHashCodes(this.responseAccessToken, this.responseRefreshToken, this.responseExpiresIn, this.refreshTokenWhen);
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getClientId() {
        return this.clientId;
    }

    public abstract boolean isEncodeClientCredentialsInBody();

    public String getScopes() {
        return this.scopes;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public Literal<Boolean> getRefreshTokenWhen() {
        return this.refreshTokenWhen;
    }

    public Literal<String> getResponseAccessToken() {
        return this.responseAccessToken;
    }

    public Literal<String> getResponseRefreshToken() {
        return this.responseRefreshToken;
    }

    public Literal<String> getResponseExpiresIn() {
        return this.responseExpiresIn;
    }

    public List<ParameterExtractor> getCustomParameterExtractors() {
        return this.customParameterExtractors != null ? this.customParameterExtractors : Collections.emptyList();
    }

    public TlsContextFactory getTlsContextFactory() {
        return this.tlsContext;
    }

    public boolean isDefaultTokenManager() {
        return this.defaultTokenManager || this.tokenManager == null;
    }

    public boolean readsAuthenticatedResponseBody() {
        return this.readsResponseBody;
    }

    public void setRefreshTokenWhen(Literal<Boolean> refreshTokenWhen) {
        this.refreshTokenWhen = refreshTokenWhen;
    }
}

