/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformer.jaxb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.message.OutputHandler;
import org.mule.runtime.core.transformer.AbstractTransformer;
import org.mule.runtime.core.util.xmlsecurity.XMLSecureFactories;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JAXBMarshallerTransformer
extends AbstractTransformer {
    protected JAXBContext jaxbContext;
    protected Class<?> sourceClass;

    public JAXBMarshallerTransformer() {
        this.setReturnDataType(DataType.fromType(OutputStream.class));
        this.registerSourceType(DataType.OBJECT);
    }

    public JAXBMarshallerTransformer(JAXBContext jaxbContext, DataType returnType) {
        this();
        this.jaxbContext = jaxbContext;
        this.setReturnDataType(returnType);
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.jaxbContext == null) {
            throw new InitialisationException(CoreMessages.objectIsNull((String)"jaxbContext"), (Initialisable)this);
        }
    }

    protected Object doTransform(Object src, Charset encoding) throws TransformerException {
        try {
            Marshaller m = this.jaxbContext.createMarshaller();
            if (String.class.isAssignableFrom(this.getReturnDataType().getType())) {
                StringWriter w = new StringWriter();
                m.marshal(src, (Writer)w);
                return ((Object)w).toString();
            }
            if (this.getReturnDataType().getType().isAssignableFrom(Writer.class)) {
                StringWriter w = new StringWriter();
                m.marshal(src, (Writer)w);
                return w;
            }
            if (Document.class.isAssignableFrom(this.getReturnDataType().getType())) {
                DocumentBuilderFactory factory = XMLSecureFactories.createDefault().getDocumentBuilderFactory();
                Document doc = factory.newDocumentBuilder().newDocument();
                m.marshal(src, (Node)doc);
                return doc;
            }
            if (OutputStream.class.isAssignableFrom(this.getReturnDataType().getType())) {
                ByteArrayOutputStream out2 = new ByteArrayOutputStream();
                m.marshal(src, (OutputStream)out2);
                return out2;
            }
            if (OutputHandler.class.isAssignableFrom(this.getReturnDataType().getType())) {
                return (event, out) -> {
                    try {
                        m.marshal(src, out);
                    }
                    catch (JAXBException e) {
                        IOException iox = new IOException("failed to mashal objec tto XML");
                        iox.initCause(e);
                        throw iox;
                    }
                };
            }
            throw new TransformerException(CoreMessages.transformerInvalidReturnType((Class)this.getReturnDataType().getType(), (String)this.getName()));
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public void setJaxbContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    public void setSourceClass(Class<?> sourceClass) {
        this.sourceClass = sourceClass;
    }
}

